/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.GuiUtils;
import com.intellij.util.SystemProperties;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.X509Certificate;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.ServerSSLDialog;
import org.jetbrains.idea.svn.dialogs.SvnInteractiveAuthenticationProvider;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class SvnAuthenticationProvider
implements ISVNAuthenticationProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.dialogs.SvnAuthenticationProvider");
    private final Project myProject;
    private final SvnAuthenticationNotifier myAuthenticationNotifier;
    private final SvnInteractiveAuthenticationProvider mySvnInteractiveAuthenticationProvider;

    public SvnAuthenticationProvider(SvnVcs svnVcs, SvnAuthenticationManager manager) {
        this.myProject = svnVcs.getProject();
        this.myAuthenticationNotifier = svnVcs.getAuthNotifier();
        this.mySvnInteractiveAuthenticationProvider = new SvnInteractiveAuthenticationProvider(svnVcs, manager);
    }

    private void log(String s) {
        LOG.debug(s);
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        if (ApplicationManager.getApplication().isUnitTestMode() && "svn.username".equals(kind)) {
            String userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : SystemProperties.getUserName();
            return new SVNUserNameAuthentication(userName, false);
        }
        SvnAuthenticationNotifier.AuthenticationRequest obj = new SvnAuthenticationNotifier.AuthenticationRequest(this.myProject, kind, url, realm);
        SVNURL wcUrl = this.myAuthenticationNotifier.getWcUrl(obj);
        if (wcUrl == null) {
            return this.mySvnInteractiveAuthenticationProvider.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
        }
        this.myAuthenticationNotifier.ensureNotify(obj);
        return null;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, final Object certificate, final boolean resultMayBeStored) {
        if (!(certificate instanceof X509Certificate)) {
            return 2;
        }
        final int[] result = new int[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ServerSSLDialog dialog = new ServerSSLDialog(SvnAuthenticationProvider.this.myProject, (X509Certificate)certificate, resultMayBeStored);
                dialog.show();
                result[0] = dialog.getResult();
            }
        };
        try {
            GuiUtils.runOrInvokeAndWait((Runnable)command);
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return result[0];
    }
}

