/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.update.SvnPanel;

public class MultipleRootsEditor {
    private JList myList;
    private JPanel myConfigureRootPanel;
    private JPanel myPanel;
    @NonNls
    private static final String EMPTY = "empty";

    public MultipleRootsEditor(Map<FilePath, SvnPanel> rootToPanel, final Project project) {
        this.$$$setupUI$$$();
        final CardLayout layout = new CardLayout();
        this.myConfigureRootPanel.setLayout(layout);
        DefaultListModel<FilePath> listModel = new DefaultListModel<FilePath>();
        layout.addLayoutComponent(new JPanel(), EMPTY);
        for (FilePath root : rootToPanel.keySet()) {
            this.myConfigureRootPanel.add((Component)rootToPanel.get(root).getPanel(), root.getPath());
            listModel.addElement(root);
        }
        this.myConfigureRootPanel.revalidate();
        this.myList.setModel(listModel);
        this.myList.getSelectionModel().setSelectionMode(0);
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof FilePath) {
                    FilePath path = (FilePath)value;
                    if (path.getVirtualFile() != null) {
                        this.append(VcsPathPresenter.getInstance((Project)project).getPresentableRelativePathFor(path.getVirtualFile()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(VcsPathPresenter.getInstance((Project)project).getPresentableRelativePathFor(path.getVirtualFileParent()) + File.separator + path.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }
        });
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FilePath root = (FilePath)MultipleRootsEditor.this.myList.getSelectedValue();
                if (root != null) {
                    layout.show(MultipleRootsEditor.this.myConfigureRootPanel, root.getPath());
                } else {
                    layout.show(MultipleRootsEditor.this.myConfigureRootPanel, MultipleRootsEditor.EMPTY);
                }
            }
        });
        this.myList.setSelectedIndex(0);
        this.myList.requestFocus();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(4, 4, 0, 0), -1, -1, false, false));
        this.myConfigureRootPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("nulty.roots.update.configuration.selected.root.setting.group.title"), 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myList = jList = new JList();
        jScrollPane.setViewportView(jList);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("nulty.roots.update.configuration.affected.roots.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

