/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.jetbrains.idea.svn.update.SvnUpdateRootOptionsPanel;

public class SvnUpdatePanel
extends AbstractSvnUpdatePanel {
    private JPanel myConfigureRootsPanel;
    private JCheckBox myStatusBox;
    private JPanel myPanel;
    private JCheckBox myLockOnDemand;
    private DepthCombo myDepthCombo;
    private JLabel myDepthLabel;

    public SvnUpdatePanel(SvnVcs vcs, Collection<FilePath> roots) {
        super(vcs);
        this.$$$setupUI$$$();
        this.init(roots);
        boolean descend = false;
        for (FilePath root : roots) {
            if (!root.isDirectory()) continue;
            descend = true;
            break;
        }
        this.myDepthCombo.setVisible(descend);
        this.myDepthLabel.setVisible(descend);
        this.myDepthLabel.setLabelFor(this.myDepthCombo);
        boolean enable = true;
        this.myLockOnDemand.setVisible(true);
        this.myLockOnDemand.setSelected(SvnConfiguration.getInstance((Project)this.myVCS.getProject()).UPDATE_LOCK_ON_DEMAND);
        this.myLockOnDemand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnConfiguration.getInstance((Project)SvnUpdatePanel.this.myVCS.getProject()).UPDATE_LOCK_ON_DEMAND = SvnUpdatePanel.this.myLockOnDemand.isSelected();
            }
        });
    }

    @Override
    protected JPanel getRootsPanel() {
        return this.myConfigureRootsPanel;
    }

    @Override
    protected SvnPanel createRootPanel(FilePath root, SvnVcs vcs, Collection<FilePath> roots) {
        return new SvnUpdateRootOptionsPanel(root, vcs, roots);
    }

    @Override
    protected JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getStatusBox() {
        return this.myStatusBox;
    }

    @Override
    protected DepthCombo getDepthBox() {
        return this.myDepthCombo;
    }

    private void createUIComponents() {
        this.myLockOnDemand = new JCheckBox(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        DepthCombo depthCombo;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConfigureRootsPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDepthCombo = depthCombo = new DepthCombo();
        jPanel2.add((Component)depthCombo, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myDepthLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.text"));
        jLabel.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.description"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStatusBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.update.switch.configurable.run.status"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JCheckBox jCheckBox2 = this.myLockOnDemand;
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.description"));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.text"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 1, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

