/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.ITestContext;
import org.testng.TestNGException;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.FactoryMethod;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGClassFinder
extends BaseClassFinder {
    private ITestContext m_testContext = null;
    private Map<Class, List<Object>> m_instanceMap = new HashMap<Class, List<Object>>();

    public TestNGClassFinder(Class[] classes, Map<Class, List<Object>> instanceMap, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext) {
        this.m_testContext = testContext;
        if (null == instanceMap) {
            instanceMap = new HashMap<Class, List<Object>>();
        }
        Class[] allClasses = classes;
        IObjectFactory objectFactory = testContext.getSuite().getObjectFactory();
        if (objectFactory == null) {
            objectFactory = new ObjectFactoryImpl();
            block4: for (Class cls : allClasses) {
                try {
                    if (null == cls) continue;
                    for (Method m : cls.getMethods()) {
                        IAnnotation a = annotationFinder.findAnnotation(m, IObjectFactoryAnnotation.class);
                        if (null == a) continue;
                        if (!IObjectFactory.class.isAssignableFrom(m.getReturnType())) {
                            throw new TestNGException("Return type of " + m + " is not IObjectFactory");
                        }
                        try {
                            Object instance = cls.newInstance();
                            if (m.getParameterTypes().length > 0 && m.getParameterTypes()[0].equals(ITestContext.class)) {
                                objectFactory = (IObjectFactory)m.invoke(instance, testContext);
                                break block4;
                            }
                            objectFactory = (IObjectFactory)m.invoke(instance, new Object[0]);
                            break block4;
                        }
                        catch (Exception ex) {
                            throw new TestNGException("Error creating object factory", ex);
                        }
                    }
                }
                catch (NoClassDefFoundError e) {
                    Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + cls.getName() + " - unable to resolve class reference " + e.getMessage());
                    for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                        if (xmlClass.getDeclaredClass() != Boolean.TRUE || !xmlClass.getName().equals(cls.getName())) continue;
                        throw e;
                    }
                }
            }
        }
        for (Class cls : allClasses) {
            if (null == cls) {
                TestNGClassFinder.ppp("FOUND NULL CLASS IN FOLLOWING ARRAY:");
                int i = 0;
                for (Class c : allClasses) {
                    TestNGClassFinder.ppp("  " + i + ": " + c);
                }
                continue;
            }
            if (TestNGClassFinder.isTestNGClass(cls, annotationFinder)) {
                Object thisInstance;
                List<Object> allInstances = instanceMap.get(cls);
                Object object = thisInstance = null != allInstances ? allInstances.get(0) : null;
                if (null == thisInstance && Modifier.isAbstract(cls.getModifiers())) {
                    Utils.log("", 5, "[WARN] Found an abstract class with no valid instance attached: " + cls);
                    continue;
                }
                IClass ic = this.findOrCreateIClass(cls, thisInstance, xmlTest, annotationFinder, objectFactory);
                if (null == ic) continue;
                Object[] theseInstances = ic.getInstances(false);
                if (theseInstances.length == 0) {
                    theseInstances = ic.getInstances(true);
                }
                Object instance = theseInstances[0];
                this.putIClass(cls, ic);
                Method factoryMethod = ClassHelper.findFactoryMethod(cls, annotationFinder);
                if (null == factoryMethod) continue;
                FactoryMethod fm = new FactoryMethod(factoryMethod, instance, xmlTest, annotationFinder, this.m_testContext);
                ArrayList moreClasses = new ArrayList();
                Object[] instances = fm.invoke();
                if (instances.length > 0) {
                    Class<?> elementClass = instances[0].getClass();
                    if (IInstanceInfo.class.isAssignableFrom(elementClass)) {
                        for (Object o : instances) {
                            IInstanceInfo ii = (IInstanceInfo)o;
                            this.addInstance(ii.getInstanceClass(), ii.getInstance());
                            moreClasses.add(ii.getInstanceClass());
                        }
                    } else {
                        for (Object o : instances) {
                            this.addInstance(o.getClass(), o);
                            if (this.classExists(o.getClass())) continue;
                            moreClasses.add(o.getClass());
                        }
                    }
                }
                if (moreClasses.size() <= 0) continue;
                TestNGClassFinder finder = new TestNGClassFinder(moreClasses.toArray(new Class[moreClasses.size()]), this.m_instanceMap, xmlTest, annotationFinder, this.m_testContext);
                IClass[] moreIClasses = finder.findTestClasses();
                for (IClass ic2 : moreIClasses) {
                    this.putIClass(ic2.getRealClass(), ic2);
                }
                continue;
            }
            Utils.log("TestNGClassFinder", 3, "SKIPPING CLASS " + cls + " no TestNG annotations found");
        }
        for (Class c : this.m_instanceMap.keySet()) {
            List<Object> instances = this.m_instanceMap.get(c);
            for (Object instance : instances) {
                IClass ic = this.getIClass(c);
                if (null == ic) continue;
                ic.addInstance(instance);
            }
        }
    }

    public static boolean isTestNGClass(Class cls, IAnnotationFinder annotationFinder) {
        Class[] allAnnotations = AnnotationHelper.getAllAnnotations();
        try {
            for (Class annotation : allAnnotations) {
                for (Method m : cls.getMethods()) {
                    IAnnotation ma = annotationFinder.findAnnotation(m, annotation);
                    if (null == ma) continue;
                    return true;
                }
                IAnnotation a = annotationFinder.findAnnotation(cls, annotation);
                if (null != a) {
                    return true;
                }
                for (Constructor<?> ctor : cls.getConstructors()) {
                    IAnnotation ca = annotationFinder.findAnnotation(ctor, annotation);
                    if (null == ca) continue;
                    return true;
                }
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + cls.getName() + " - unable to resolve class reference " + e.getMessage());
            return false;
        }
    }

    private void addInstance(Class clazz, Object o) {
        List<Object> list = this.m_instanceMap.get(clazz);
        if (null == list) {
            list = new ArrayList<Object>();
            this.m_instanceMap.put(clazz, list);
        }
        list.add(o);
    }

    public static void ppp(String s) {
        System.out.println("[TestNGClassFinder] " + s);
    }
}

