/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.engine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.compress.CompressedDictionary;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.EditableDictionaryLoader;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.engine.LevenshteinDistance;
import com.intellij.spellchecker.engine.Metrics;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.spellchecker.engine.Transformation;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseSpellChecker
implements SpellCheckerEngine {
    private Transformation transform = new Transformation();
    private final Set<EditableDictionary> dictionaries = new THashSet();
    private final Set<Dictionary> bundledDictionaries = new THashSet();
    private Metrics metrics = new LevenshteinDistance();

    @Override
    public void loadDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.loadDictionary must not be null");
        }
        if (loader instanceof EditableDictionaryLoader) {
            EditableDictionary dictionary = ((EditableDictionaryLoader)loader).getDictionary();
            if (dictionary != null) {
                this.addModifiableDictionary(dictionary);
            }
        } else {
            this.loadFixedDictionary(loader);
        }
    }

    private void loadFixedDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.loadFixedDictionary must not be null");
        }
        this.loadCompressedDictionary(loader);
    }

    private void loadCompressedDictionary(@NotNull Loader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.loadCompressedDictionary must not be null");
        }
        CompressedDictionary dictionary = CompressedDictionary.create(loader, this.transform);
        if (dictionary != null) {
            this.addCompressedFixedDictionary(dictionary);
        }
    }

    private void addModifiableDictionary(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.addModifiableDictionary must not be null");
        }
        this.dictionaries.add(dictionary);
    }

    private void addCompressedFixedDictionary(@NotNull Dictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.addCompressedFixedDictionary must not be null");
        }
        this.bundledDictionaries.add(dictionary);
    }

    @Override
    public Transformation getTransformation() {
        return this.transform;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<String> restore(@NotNull Character startFrom, int i, int j, @Nullable Collection dictionaries) {
        List<String> list;
        if (startFrom == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.restore must not be null");
        }
        if (dictionaries == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.restore must not return null");
            return list;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Object o : dictionaries) {
            if (!(o instanceof Dictionary)) continue;
            results.addAll(BaseSpellChecker.restore(startFrom, i, j, (Dictionary)o));
        }
        list = results;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.restore must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<String> restore(final @NotNull Character first, final int i, final int j, @Nullable Dictionary dictionary) {
        List<String> list;
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.restore must not be null");
        }
        if (dictionary == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.restore must not return null");
            return list;
        }
        final ArrayList<String> result = new ArrayList<String>();
        if (dictionary instanceof CompressedDictionary) {
            result.addAll(((CompressedDictionary)dictionary).getWords(first));
        } else {
            dictionary.traverse(new Consumer<String>(){

                public void consume(String s) {
                    if (StringUtil.isEmpty((String)s)) {
                        return;
                    }
                    if (s.charAt(0) == first.charValue() && s.length() >= i && s.length() <= j) {
                        result.add(s);
                    }
                }
            });
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.restore must not return null");
    }

    private static boolean isCorrect(@NotNull String transformed, @Nullable Collection dictionaries) {
        if (transformed == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.isCorrect must not be null");
        }
        if (dictionaries == null) {
            return true;
        }
        for (Object o : dictionaries) {
            boolean result;
            if (!(o instanceof Dictionary) || !(result = BaseSpellChecker.isCorrect(transformed, (Dictionary)o))) continue;
            return true;
        }
        return false;
    }

    private static boolean isCorrect(@NotNull String transformed, @Nullable Dictionary dictionary) {
        if (transformed == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.isCorrect must not be null");
        }
        if (dictionary == null) {
            return true;
        }
        return dictionary.contains(transformed);
    }

    @Override
    public boolean isCorrect(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.isCorrect must not be null");
        }
        String transformed = this.transform.transform(word);
        if (transformed == null) {
            return true;
        }
        return BaseSpellChecker.isCorrect(transformed, this.bundledDictionaries) || BaseSpellChecker.isCorrect(transformed, this.dictionaries);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<String> getSuggestions(@NotNull String word, int threshold, int quality) {
        List<String> list;
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.getSuggestions must not be null");
        }
        String transformed = this.transform.transform(word);
        if (transformed == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.getSuggestions must not return null");
            return list;
        }
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        List<String> rawSuggestions = BaseSpellChecker.restore(Character.valueOf(transformed.charAt(0)), 0, Integer.MAX_VALUE, this.bundledDictionaries);
        rawSuggestions.addAll(BaseSpellChecker.restore(Character.valueOf(word.charAt(0)), 0, Integer.MAX_VALUE, this.dictionaries));
        for (String rawSuggestion : rawSuggestions) {
            int distance = this.metrics.calculateMetrics(transformed, rawSuggestion);
            suggestions.add(new Suggestion(rawSuggestion, distance));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (suggestions.isEmpty()) {
            list = result;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.getSuggestions must not return null");
            return list;
        }
        Collections.sort(suggestions);
        int bestMetrics = ((Suggestion)suggestions.get(0)).getMetrics();
        for (int i = 0; i < threshold && suggestions.size() >= i && bestMetrics - ((Suggestion)suggestions.get(i)).getMetrics() <= quality; ++i) {
            result.add(i, ((Suggestion)suggestions.get(i)).getWord());
        }
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.getSuggestions must not return null");
    }

    @Override
    @NotNull
    public List<String> getVariants(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.getVariants must not be null");
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/spellchecker/engine/BaseSpellChecker.getVariants must not return null");
        }
        return list;
    }

    @Override
    public void reset() {
        this.bundledDictionaries.clear();
        this.dictionaries.clear();
    }

    @Override
    public boolean isDictionaryLoad(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.isDictionaryLoad must not be null");
        }
        return this.getBundledDictionaryByName(name) != null;
    }

    @Override
    public void removeDictionary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.removeDictionary must not be null");
        }
        Iterator<Dictionary> iterator = this.bundledDictionaries.iterator();
        while (iterator.hasNext()) {
            Dictionary dictionary = iterator.next();
            if (!name.equals(dictionary.getName())) continue;
            iterator.remove();
            break;
        }
    }

    @Nullable
    public Dictionary getBundledDictionaryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/spellchecker/engine/BaseSpellChecker.getBundledDictionaryByName must not be null");
        }
        if (this.bundledDictionaries == null) {
            return null;
        }
        for (Dictionary dictionary : this.bundledDictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return dictionary;
        }
        return null;
    }
}

