/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesFileStructureViewElement;
import com.intellij.lang.properties.structureView.PropertiesPrefixGroup;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileStructureViewModel
extends TextEditorBasedStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final PropertiesFile myPropertiesFile;
    private final GroupByWordPrefixes myGroupByWordPrefixes;
    @NonNls
    public static final String KIND_SORTER_ID = "KIND_SORTER";
    private static final Sorter KIND_SORTER = new Sorter(){

        public Comparator getComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    int weight1 = o1 instanceof PropertiesPrefixGroup ? 1 : 0;
                    int weight2 = o2 instanceof PropertiesPrefixGroup ? 1 : 0;
                    return weight1 - weight2;
                }
            };
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            String name = IdeBundle.message((String)"action.sort.by.type", (Object[])new Object[0]);
            ActionPresentationData actionPresentationData = new ActionPresentationData(name, name, IconLoader.getIcon((String)"/objectBrowser/sortByType.png"));
            if (actionPresentationData == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1.getPresentation must not return null");
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            if (PropertiesFileStructureViewModel.KIND_SORTER_ID == null) {
                throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel$1.getName must not return null");
            }
            return PropertiesFileStructureViewModel.KIND_SORTER_ID;
        }
    };

    public PropertiesFileStructureViewModel(PropertiesFile root) {
        super((PsiFile)root);
        this.myPropertiesFile = root;
        String separator = PropertiesSeparatorManager.getInstance().getSeparator(root.getProject(), root.getVirtualFile());
        this.myGroupByWordPrefixes = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myGroupByWordPrefixes.setSeparator(separator);
        PropertiesSeparatorManager.getInstance().setSeparator(this.myPropertiesFile.getVirtualFile(), separator);
    }

    @Override
    public String getSeparator() {
        return this.myGroupByWordPrefixes.getSeparator();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        PropertiesFileStructureViewElement propertiesFileStructureViewElement = new PropertiesFileStructureViewElement(this.myPropertiesFile);
        if (propertiesFileStructureViewElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel.getRoot must not return null");
        }
        return propertiesFileStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{this.myGroupByWordPrefixes};
        if (grouperArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel.getGroupers must not return null");
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER, KIND_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel.getSorters must not return null");
        }
        return sorterArray;
    }

    protected PsiFile getPsiFile() {
        return this.myPropertiesFile;
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        Class[] classArray = new Class[]{Property.class};
        if (classArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/structureView/PropertiesFileStructureViewModel.getSuitableClasses must not return null");
        }
        return classArray;
    }
}

