/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;

public class EJavadocUtil {
    private EJavadocUtil() {
    }

    static void appendJavadocRoots(Element element, ModuleRootModel model, List<String> currentRoots, Library.ModifiableModel modifiableModel) {
        Element attributes = element.getChild("attributes");
        if (attributes == null) {
            return;
        }
        for (Object o : attributes.getChildren("attribute")) {
            if (!Comparing.strEqual((String)((Element)o).getAttributeValue("name"), (String)"javadoc_location")) continue;
            Element attribute = (Element)o;
            String javadocPath = attribute.getAttributeValue("value");
            if (!SystemInfo.isWindows) {
                javadocPath = javadocPath.replaceFirst("file:/", "file://");
            }
            modifiableModel.addRoot(EJavadocUtil.toIdeaJavadocUrl(model, javadocPath, currentRoots), JavadocOrderRootType.getInstance());
        }
    }

    private static String toIdeaJavadocUrl(ModuleRootModel model, String javadocPath, List<String> currentRoots) {
        if (javadocPath.startsWith("file:/")) {
            if (new File(javadocPath.substring("file:/".length())).exists()) {
                return VfsUtil.pathToUrl((String)javadocPath.substring("file:/".length()));
            }
        } else {
            String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
            if (Comparing.strEqual((String)protocol, (String)HttpFileSystem.getInstance().getProtocol())) {
                return javadocPath;
            }
            if (javadocPath.startsWith("jar:")) {
                String localFile;
                String jarJavadocPath = javadocPath.substring("jar:".length());
                if (jarJavadocPath.startsWith("platform:/")) {
                    String relativeToPlatform = jarJavadocPath.substring("platform:/".length() + "resource".length());
                    VirtualFile currentRoot = EPathUtil.getContentRoot(model);
                    String currentModulePath = (currentRoot != null ? currentRoot.getParent().getPath() : model.getModule().getProject().getBaseDir().getPath()) + relativeToPlatform;
                    if (EJavadocUtil.isJarFileExist(currentModulePath)) {
                        return VirtualFileManager.constructUrl((String)"jar", (String)currentModulePath);
                    }
                    String moduleName = EPathUtil.getRelativeModuleName(relativeToPlatform);
                    String relativeToModulePathWithJarSuffix = EPathUtil.getRelativeToModulePath(relativeToPlatform);
                    String relativeToModulePath = EJavadocUtil.stripPathInsideJar(relativeToModulePathWithJarSuffix);
                    Module otherModule = ModuleManager.getInstance((Project)model.getModule().getProject()).findModuleByName(moduleName);
                    String url = null;
                    if (otherModule != null && otherModule != model.getModule()) {
                        url = EPathUtil.expandEclipseRelative2OtherModule(otherModule, relativeToModulePath);
                    } else if (currentRoots != null) {
                        url = EPathUtil.expandEclipseRelative2ContentRoots(currentRoots, moduleName, relativeToModulePath);
                    }
                    if (url != null) {
                        assert (relativeToModulePathWithJarSuffix != null);
                        assert (relativeToModulePath != null);
                        if (relativeToModulePath.length() < relativeToModulePathWithJarSuffix.length()) {
                            url = url + relativeToModulePathWithJarSuffix.substring(relativeToModulePath.length());
                        }
                        return VirtualFileManager.constructUrl((String)"jar", (String)VfsUtil.urlToPath((String)url));
                    }
                } else if (jarJavadocPath.startsWith("file:/") && EJavadocUtil.isJarFileExist(localFile = jarJavadocPath.substring("file:/".length()))) {
                    return VirtualFileManager.constructUrl((String)"jar", (String)localFile);
                }
            }
        }
        return javadocPath;
    }

    @Nullable
    private static String stripPathInsideJar(@Nullable String relativeToModulePathWithJarSuffix) {
        int jarSufIdx;
        String relativeToModulePath = relativeToModulePathWithJarSuffix;
        if (relativeToModulePath != null && (jarSufIdx = relativeToModulePathWithJarSuffix.indexOf("!/")) != -1) {
            relativeToModulePath = relativeToModulePath.substring(0, jarSufIdx);
        }
        return relativeToModulePath;
    }

    static boolean isJarFileExist(String path) {
        int jarSufIdx = path.indexOf("!/");
        if (jarSufIdx != -1) {
            path = path.substring(0, jarSufIdx);
        }
        return new File(path).exists();
    }

    private static String toEclipseJavadocPath(ModuleRootModel model, String javadocPath) {
        String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
        if (!Comparing.strEqual((String)protocol, (String)HttpFileSystem.getInstance().getProtocol())) {
            VirtualFile baseDir;
            String path = VfsUtil.urlToPath((String)javadocPath);
            VirtualFile contentRoot = EPathUtil.getContentRoot(model);
            Project project = model.getModule().getProject();
            VirtualFile virtualFile = baseDir = contentRoot != null ? contentRoot.getParent() : project.getBaseDir();
            if (Comparing.strEqual((String)protocol, (String)JarFileSystem.getInstance().getProtocol())) {
                VirtualFile javadocFile = JarFileSystem.getInstance().getVirtualFileForJar(VirtualFileManager.getInstance().findFileByUrl(javadocPath));
                if (javadocFile != null) {
                    String relativeUrl = contentRoot != null && VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)javadocFile, (boolean)false) ? "/" + VfsUtil.getRelativePath((VirtualFile)javadocFile, (VirtualFile)baseDir, (char)'/') : EPathUtil.collapse2eclipseRelative2OtherModule(project, javadocFile);
                    if (relativeUrl != null) {
                        if (javadocPath.indexOf("!/") == -1) {
                            javadocPath = StringUtil.trimEnd((String)javadocPath, (String)"/") + "!/";
                        }
                        javadocPath = "jar:platform:/resource" + relativeUrl + javadocPath.substring(javadocFile.getUrl().length() - 1);
                    } else {
                        javadocPath = "jar:file:/" + StringUtil.trimStart((String)path, (String)"/");
                    }
                } else {
                    javadocPath = "jar:file:/" + StringUtil.trimStart((String)path, (String)"/");
                }
            } else if (new File(path).exists()) {
                javadocPath = "file:/" + StringUtil.trimStart((String)path, (String)"/");
            }
        }
        return javadocPath;
    }

    static void setupJavadocAttributes(Element orderEntry, LibraryOrderEntry libraryOrderEntry, ModuleRootModel model) {
        String[] docUrls;
        ArrayList<String> eclipseUrls = new ArrayList<String>();
        for (String docUrl : docUrls = libraryOrderEntry.getUrls(JavadocOrderRootType.getInstance())) {
            eclipseUrls.add(EJavadocUtil.toEclipseJavadocPath(model, docUrl));
        }
        ArrayList children = new ArrayList(orderEntry.getChildren("attributes"));
        for (Object o : children) {
            Element attsElement = (Element)o;
            ArrayList attTags = new ArrayList(attsElement.getChildren("attribute"));
            for (Object a : attTags) {
                String javadocPath;
                Element attElement = (Element)a;
                if (!Comparing.strEqual((String)attElement.getAttributeValue("name"), (String)"javadoc_location") || eclipseUrls.remove(javadocPath = attElement.getAttributeValue("value"))) continue;
                attElement.detach();
            }
        }
        for (String docUrl : eclipseUrls) {
            Element child = orderEntry.getChild("attributes");
            if (child == null) {
                child = new Element("attributes");
                orderEntry.addContent(child);
            }
            Element attrElement = new Element("attribute");
            child.addContent(attrElement);
            attrElement.setAttribute("name", "javadoc_location");
            attrElement.setAttribute("value", docUrl);
        }
    }
}

