/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.explorer.AntBuildFileNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AntExplorerTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.explorer.AntExplorerTreeStructure");
    private final Project myProject;
    private final Object myRoot = new Object();
    private boolean myFilteredTargets = false;
    private static final Comparator<AntBuildTarget> ourTargetComparator = new Comparator<AntBuildTarget>(){

        @Override
        public int compare(AntBuildTarget target1, AntBuildTarget target2) {
            String name1 = target1.getDisplayName();
            if (name1 == null) {
                return Integer.MIN_VALUE;
            }
            String name2 = target2.getDisplayName();
            if (name2 == null) {
                return Integer.MAX_VALUE;
            }
            return name1.compareToIgnoreCase(name2);
        }
    };

    public AntExplorerTreeStructure(Project project) {
        this.myProject = project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AntNodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        AntNodeDescriptor antNodeDescriptor;
        if (element == this.myRoot) {
            RootNodeDescriptor rootNodeDescriptor = new RootNodeDescriptor(this.myProject, parentDescriptor);
            antNodeDescriptor = rootNodeDescriptor;
            if (rootNodeDescriptor != null) return antNodeDescriptor;
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure.createDescriptor must not return null");
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(this.myProject, parentDescriptor, (String)element);
            antNodeDescriptor = textInfoNodeDescriptor;
            if (textInfoNodeDescriptor == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure.createDescriptor must not return null");
            return antNodeDescriptor;
        }
        if (element instanceof AntBuildFile) {
            AntBuildFileNodeDescriptor antBuildFileNodeDescriptor = new AntBuildFileNodeDescriptor(this.myProject, parentDescriptor, (AntBuildFileBase)element);
            antNodeDescriptor = antBuildFileNodeDescriptor;
            if (antBuildFileNodeDescriptor == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure.createDescriptor must not return null");
            return antNodeDescriptor;
        }
        if (element instanceof AntBuildTarget) {
            AntTargetNodeDescriptor antTargetNodeDescriptor = new AntTargetNodeDescriptor(this.myProject, parentDescriptor, (AntBuildTargetBase)element);
            antNodeDescriptor = antTargetNodeDescriptor;
            if (antTargetNodeDescriptor == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure.createDescriptor must not return null");
            return antNodeDescriptor;
        }
        LOG.error("Unknown element for this tree structure " + element);
        antNodeDescriptor = null;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure.createDescriptor must not return null");
    }

    public Object[] getChildElements(Object element) {
        AntConfiguration configuration = AntConfiguration.getInstance(this.myProject);
        if (element == this.myRoot) {
            Object[] objectArray;
            if (!configuration.isInitialized()) {
                return new Object[]{AntBundle.message("loading.ant.config.progress", new Object[0])};
            }
            Object[] buildFiles = configuration.getBuildFiles();
            if (buildFiles.length != 0) {
                objectArray = buildFiles;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = AntBundle.message("ant.tree.structure.no.build.files.message", new Object[0]);
            }
            return objectArray;
        }
        if (element instanceof AntBuildFile) {
            AntBuildFile buildFile = (AntBuildFile)element;
            AntBuildModel model = buildFile.getModel();
            ArrayList<AntBuildTarget> targets = new ArrayList<AntBuildTarget>(Arrays.asList(this.myFilteredTargets ? model.getFilteredTargets() : model.getTargets()));
            Collections.sort(targets, ourTargetComparator);
            List<AntBuildTarget> metaTargets = Arrays.asList(configuration.getMetaTargets(buildFile));
            Collections.sort(metaTargets, ourTargetComparator);
            targets.addAll(metaTargets);
            return targets.toArray(new AntBuildTargetBase[targets.size()]);
        }
        if (element instanceof AntBuildTarget) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object getParentElement(Object element) {
        if (element instanceof AntBuildTarget) {
            if (element instanceof MetaTarget) {
                return ((MetaTarget)element).getBuildFile();
            }
            AntBuildTargetBase buildTarget = (AntBuildTargetBase)element;
            return buildTarget.getModel().getBuildFile();
        }
        if (element instanceof AntBuildFile) {
            return this.myRoot;
        }
        return null;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    public Object getRootElement() {
        return this.myRoot;
    }

    public void setFilteredTargets(boolean value) {
        this.myFilteredTargets = value;
    }

    private static final class TextInfoNodeDescriptor
    extends AntNodeDescriptor {
        public TextInfoNodeDescriptor(Project project, NodeDescriptor parentDescriptor, String text) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = Color.blue;
        }

        public Object getElement() {
            return this.myName;
        }

        public boolean update() {
            return true;
        }

        @Override
        public boolean isAutoExpand() {
            return true;
        }
    }

    private final class RootNodeDescriptor
    extends AntNodeDescriptor {
        public RootNodeDescriptor(Project project, NodeDescriptor parentDescriptor) {
            super(project, parentDescriptor);
        }

        @Override
        public boolean isAutoExpand() {
            return true;
        }

        public Object getElement() {
            return AntExplorerTreeStructure.this.myRoot;
        }

        public boolean update() {
            this.myName = "";
            return false;
        }
    }
}

