/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.impl.AntClasspathEntry;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.util.CellAppearanceUtils;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class SinglePathEntry
implements AntClasspathEntry {
    private static final Function<VirtualFile, AntClasspathEntry> CREATE_FROM_VIRTUAL_FILE = new Function<VirtualFile, AntClasspathEntry>(){

        public AntClasspathEntry fun(VirtualFile singlePathEntry) {
            return SinglePathEntry.fromVirtulaFile(singlePathEntry);
        }
    };
    @NonNls
    static final String PATH = "path";
    private File myFile;

    public SinglePathEntry() {
    }

    public SinglePathEntry(File file) {
        this.myFile = file;
    }

    public SinglePathEntry(String ospath) {
        this(new File(ospath));
    }

    public void readExternal(Element element) throws InvalidDataException {
        String value = element.getAttributeValue(PATH);
        this.myFile = new File(PathUtil.toPresentableUrl((String)value));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        String url = VirtualFileManager.constructUrl((String)"file", (String)this.myFile.getAbsolutePath().replace(File.separatorChar, '/'));
        element.setAttribute(PATH, url);
    }

    @Override
    public void addFilesTo(List<File> files) {
        files.add(this.myFile);
    }

    @Override
    public CompositeAppearance getAppearance() {
        return CellAppearanceUtils.forFile((File)this.myFile);
    }

    @Override
    public String getPresentablePath() {
        return this.myFile.getAbsolutePath();
    }

    public static SinglePathEntry fromVirtulaFile(VirtualFile file) {
        return new SinglePathEntry(file.getPresentableUrl());
    }

    public static class AddEntriesFactory
    implements Factory<List<AntClasspathEntry>> {
        private final JComponent myParentComponent;

        public AddEntriesFactory(JComponent parentComponent) {
            this.myParentComponent = parentComponent;
        }

        public List<AntClasspathEntry> create() {
            Object[] files = FileChooser.chooseFiles((Component)this.myParentComponent, (FileChooserDescriptor)new FileChooserDescriptor(false, true, true, true, false, true));
            if (files.length == 0) {
                return null;
            }
            return ContainerUtil.map((Object[])files, (Function)CREATE_FROM_VIRTUAL_FILE);
        }
    }
}

