/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.impl.AntPattern;
import com.intellij.lang.ant.psi.impl.AntStructuredElementImpl;
import com.intellij.lang.ant.psi.impl.reference.AntRefIdReference;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntFilesProviderImpl
extends AntStructuredElementImpl
implements AntFilesProvider {
    private AntPattern myPattern;
    private volatile SoftReference<List<File>> myCachedFiles;

    public AntFilesProviderImpl(AntElement parent, XmlTag sourceElement) {
        super(parent, sourceElement);
    }

    public AntFilesProviderImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        super(parent, sourceElement, definition, nameElementAttribute);
    }

    public AntFilesProviderImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            this.myPattern = null;
            this.clearCachedFiles();
            AntElement parent = this.getAntParent();
            if (parent != null) {
                parent.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedFiles() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myCachedFiles = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final List<File> getFiles(Set<AntFilesProvider> processed) {
        List<File> result;
        List<File> list;
        if (processed.contains(this)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFilesProviderImpl.getFiles must not return null");
            return list;
        }
        List<File> list2 = result = this.myCachedFiles == null ? null : (List<File>)this.myCachedFiles.get();
        if (result == null) {
            result = this.getFilesImpl(processed);
            this.myCachedFiles = new SoftReference(result);
        }
        if ((list = result) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFilesProviderImpl.getFiles must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getFilesImpl(Set<AntFilesProvider> processed) {
        processed.add(this);
        try {
            AntFilesProvider referenced = this.getReferencedProvider();
            if (referenced != null) {
                List<File> list = referenced.getFiles(processed);
                return list;
            }
            List<File> list = this.getFiles(this.getPattern(), processed);
            return list;
        }
        finally {
            processed.remove(this);
        }
    }

    @NotNull
    protected List<File> getFiles(AntPattern pattern, Set<AntFilesProvider> processed) {
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFilesProviderImpl.getFiles must not return null");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AntPattern getPattern() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myPattern == null) {
                this.myPattern = AntPattern.create(this, this.shouldHonorDefaultExcludes(), this.matchPatternsCaseSensitive());
            }
            return this.myPattern;
        }
    }

    @Nullable
    private AntFilesProvider getReferencedProvider() {
        PsiReference[] references;
        for (PsiReference reference : references = this.getReferences()) {
            PsiElement psiElement;
            if (!(reference instanceof AntRefIdReference) || !((psiElement = reference.resolve()) instanceof AntFilesProvider)) continue;
            return (AntFilesProvider)psiElement;
        }
        return null;
    }

    private boolean shouldHonorDefaultExcludes() {
        String value = this.getSourceElement().getAttributeValue("defaultexcludes");
        return value == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    private boolean matchPatternsCaseSensitive() {
        String value = this.getSourceElement().getAttributeValue("casesensitive");
        return value == null || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    @Nullable
    protected File getCanonicalFile(String path) {
        if (path == null) {
            return null;
        }
        try {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file.getCanonicalFile();
            }
            String baseDir = this.computeAttributeValue("${basedir}");
            if (baseDir == null) {
                return null;
            }
            return new File(baseDir, path).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }
}

