/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntElementVisitor;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProperty;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.AntElementImpl;
import com.intellij.lang.ant.psi.impl.AntTaskImpl;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.StringSetSpinAllocator;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntPropertyImpl
extends AntTaskImpl
implements AntProperty {
    private PsiElement myPropertiesFile;
    private static final Set<String> ourPropertyDefiningTags = new HashSet<String>(Arrays.asList("property", "param", "condition", "input", "available"));

    public AntPropertyImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        super(parent, sourceElement, definition, nameElementAttribute);
    }

    public AntPropertyImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        this(parent, sourceElement, definition, "name");
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntPropertyImpl.setName must not be null");
        }
        AntProperty element = (AntProperty)super.setName(name);
        AntFile antFile = this.getAntFile();
        antFile.invalidateProperties();
        return element;
    }

    @Override
    public void acceptAntElementVisitor(@NotNull AntElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntPropertyImpl.acceptAntElementVisitor must not be null");
        }
        visitor.visitAntProperty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append("AntProperty[");
            if (this.getName() != null) {
                builder.append(this.getName());
                builder.append(" = ");
                builder.append(this.getValue(null));
            } else {
                String propFile = this.getFileName();
                if (propFile != null) {
                    builder.append("file: ");
                    builder.append(propFile);
                } else {
                    builder.append(this.getSourceElement().getName());
                }
            }
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @Override
    public String getName() {
        XmlAttributeValue[] values = this.getTstampPropertyAttributeValues();
        return values.length == 1 ? values[0].getValue() : super.getName();
    }

    @Override
    public AntElementRole getRole() {
        return AntElementRole.PROPERTY_ROLE;
    }

    @Override
    public boolean canRename() {
        return super.canRename() && (!this.isTstamp() || this.getTstampPropertyAttributeValues().length > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getValue(String propName) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            XmlTag se = this.getSourceElement();
            String tagName = se.getName();
            if (ourPropertyDefiningTags.contains(tagName)) {
                Property fileProperty;
                PropertiesFile propertiesFile;
                String value = this.getPropertyValue();
                if (value == null && propName != null && (propertiesFile = this.getPropertiesFile()) != null && (fileProperty = propertiesFile.findPropertyByKey(this.cutPrefix(propName))) != null) {
                    value = fileProperty.getValue();
                }
                return value;
            }
            if ("dirname".equals(tagName)) {
                return this.getDirnameValue();
            }
            if (this.isTstamp()) {
                return this.getTstampValue(propName);
            }
            return null;
        }
    }

    private String cutPrefix(@NotNull String propName) {
        if (propName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/AntPropertyImpl.cutPrefix must not be null");
        }
        String prefix = this.getPrefix();
        if (prefix != null && propName.startsWith(prefix) && prefix.length() < propName.length() && propName.charAt(prefix.length()) == '.') {
            return propName.substring(prefix.length() + 1);
        }
        return propName;
    }

    @Override
    @Nullable
    public String getFileName() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("file"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PropertiesFile getPropertiesFile() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            if (this.myPropertiesFile == null) {
                PsiFile psiFile;
                this.myPropertiesFile = AntElementImpl.ourNull;
                String name = this.getFileName();
                if (name != null && (psiFile = this.findFileByName(name, null)) instanceof PropertiesFile) {
                    this.myPropertiesFile = psiFile;
                }
            }
            return this.myPropertiesFile == AntElementImpl.ourNull ? null : (PropertiesFile)this.myPropertiesFile;
        }
    }

    @Override
    @Nullable
    public String getPrefix() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("prefix"));
    }

    @Override
    @Nullable
    public String getEnvironment() {
        return this.computeAttributeValue(this.getSourceElement().getAttributeValue("environment"));
    }

    @Override
    @Nullable
    public String[] getNames() {
        if (this.isTstamp()) {
            return this.getTstampNames();
        }
        PropertiesFile propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            List propList = propertiesFile.getProperties();
            String prefix = this.getPrefix();
            String[] names = ArrayUtil.newStringArray((int)propList.size());
            int idx = 0;
            for (Property importedProp : propList) {
                names[idx++] = prefix != null ? prefix + "." + importedProp.getName() : importedProp.getName();
            }
            return names;
        }
        String name = this.getName();
        if (name != null) {
            if (this.getAntFile().isEnvironmentProperty(name)) {
                return this.getEnvironmentNames(name);
            }
            return new String[]{name};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            super.clearCaches();
            AntFile antFile = this.getAntFile();
            if (antFile != null) {
                antFile.clearCaches();
            }
            this.myPropertiesFile = null;
        }
    }

    @Override
    public int getTextOffset() {
        XmlAttributeValue[] values = this.getTstampPropertyAttributeValues();
        return values.length == 1 ? values[0].getTextOffset() : super.getTextOffset();
    }

    @Override
    @Nullable
    public AntElement getFormatElement(String propName) {
        for (AntElement child : this.getChildren()) {
            AntStructuredElement se;
            XmlTag tag;
            if (!(child instanceof AntStructuredElement) || !"format".equals((tag = (se = (AntStructuredElement)child).getSourceElement()).getName()) || !propName.equals(tag.getAttributeValue("property"))) continue;
            return child;
        }
        return this;
    }

    @Nullable
    private String getPropertyValue() {
        String _filePath;
        String filePath;
        XmlTag sourceElement = this.getSourceElement();
        String tagName = sourceElement.getName();
        if ("available".equals(tagName) && (filePath = sourceElement.getAttributeValue("file")) != null && (_filePath = this.computeAttributeValue(filePath)) != null && !new File(_filePath).exists()) {
            return null;
        }
        String value = sourceElement.getAttributeValue("value");
        if (value == null && (value = sourceElement.getAttributeValue("location")) == null) {
            value = sourceElement.getAttributeValue("defaultvalue");
        }
        return value;
    }

    @Nullable
    private String getDirnameValue() {
        XmlTag sourceElement = this.getSourceElement();
        String value = this.computeAttributeValue(sourceElement.getAttributeValue("file"));
        if (value != null) {
            return new File(value).getParent();
        }
        return value;
    }

    private String getTstampValue(String propName) {
        String _propName;
        String offsetStr;
        XmlTag se = this.getSourceElement();
        Date d = new Date();
        XmlTag formatTag = se.findFirstSubTag("format");
        if (formatTag != null && (offsetStr = formatTag.getAttributeValue("offset")) != null) {
            int offset;
            try {
                offset = Integer.parseInt(offsetStr);
            }
            catch (NumberFormatException e) {
                offset = 0;
            }
            String unitStr = formatTag.getAttributeValue("unit");
            int unit = 0;
            if (unitStr != null) {
                if ("millisecond".equals(unitStr)) {
                    unit = 14;
                } else if ("second".equals(unitStr)) {
                    unit = 13;
                } else if ("minute".equals(unitStr)) {
                    unit = 12;
                } else if ("hour".equals(unitStr)) {
                    unit = 11;
                } else if ("day".equals(unitStr)) {
                    unit = 5;
                } else if ("week".equals(unitStr)) {
                    unit = 3;
                } else if ("year".equals(unitStr)) {
                    unit = 1;
                }
            }
            if (offset != 0 && unit != 0) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(d);
                cal.add(unit, offset);
                d = cal.getTime();
            }
        }
        String string = _propName = propName != null ? this.cutPrefix(propName) : null;
        if (_propName != null) {
            if (_propName.equals("DSTAMP")) {
                return new SimpleDateFormat("yyyyMMdd").format(d);
            }
            if (_propName.equals("TSTAMP")) {
                return new SimpleDateFormat("HHmm").format(d);
            }
            if (_propName.equals("TODAY")) {
                return new SimpleDateFormat("MMMM d yyyy", Locale.US).format(d);
            }
        }
        for (XmlAttributeValue value : this.getTstampPropertyAttributeValues()) {
            if (value == null || _propName != null && !_propName.equals(value.getValue()) || formatTag == null) continue;
            String pattern = formatTag.getAttributeValue("pattern");
            try {
                DateFormat format = pattern != null ? new SimpleDateFormat(pattern) : DateFormat.getTimeInstance();
                String tz = formatTag.getAttributeValue("timezone");
                if (tz != null) {
                    format.setTimeZone(TimeZone.getTimeZone(tz));
                }
                return format.format(d);
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        return null;
    }

    private XmlAttributeValue[] getTstampPropertyAttributeValues() {
        if (this.isTstamp()) {
            ArrayList<XmlAttributeValue> elements = new ArrayList<XmlAttributeValue>();
            for (XmlTag formatTag : this.getSourceElement().findSubTags("format")) {
                XmlAttributeValue value;
                XmlAttribute propAttr = formatTag.getAttribute("property", null);
                if (propAttr == null || (value = propAttr.getValueElement()) == null) continue;
                elements.add(value);
            }
            return elements.toArray(new XmlAttributeValue[elements.size()]);
        }
        return new XmlAttributeValue[0];
    }

    @Override
    public boolean isTstamp() {
        return "tstamp".equals(this.getSourceElement().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTstampNames() {
        Set strings = StringSetSpinAllocator.alloc();
        try {
            String prefix = this.getSourceElement().getAttributeValue("prefix");
            if (prefix == null) {
                strings.add("DSTAMP");
                strings.add("TSTAMP");
                strings.add("TODAY");
            } else {
                prefix = prefix + '.';
                strings.add(prefix + "DSTAMP");
                strings.add(prefix + "TSTAMP");
                strings.add(prefix + "TODAY");
            }
            for (XmlAttributeValue value : this.getTstampPropertyAttributeValues()) {
                if (value == null || value.getValue() == null) continue;
                String additionalProperty = value.getValue();
                if (prefix == null) {
                    strings.add(additionalProperty);
                    continue;
                }
                strings.add(prefix + additionalProperty);
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)strings);
            return stringArray;
        }
        finally {
            StringSetSpinAllocator.dispose((Set)strings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getEnvironmentNames(String name) {
        Set strings = StringSetSpinAllocator.alloc();
        try {
            String sourceName = name.substring("env.".length());
            for (String prefix : this.getAntFile().getEnvironmentPrefixes()) {
                strings.add(prefix + sourceName);
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)strings);
            return stringArray;
        }
        finally {
            StringSetSpinAllocator.dispose((Set)strings);
        }
    }
}

