/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ant.AntElementRole;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntElementCompletionWrapper;
import com.intellij.lang.ant.psi.impl.reference.AntElementNameReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AntEndElementNameReference
extends AntElementNameReference {
    private final TextRange myRange;
    private final boolean myIsTagClosed;

    public AntEndElementNameReference(AntStructuredElement element, TextRange range, boolean isClosed) {
        super(element);
        this.myRange = range;
        this.myIsTagClosed = isClosed;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.getElement();
    }

    @NotNull
    public LookupElement[] getVariants() {
        AntStructuredElement element = this.getElement();
        final XmlTag xmlTag = element.getSourceElement();
        String completionText = this.myIsTagClosed ? element.getSourceElement().getName() : element.getSourceElement().getName() + ">";
        AntElementCompletionWrapper wrapper = new AntElementCompletionWrapper((AntElement)element.getParent(), completionText, element.getProject(), AntElementRole.TASK_ROLE){

            public PsiElement getContext() {
                return xmlTag;
            }
        };
        LookupElement[] lookupElementArray = new LookupElement[]{AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((Object)wrapper, (String)completionText))};
        if (lookupElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntEndElementNameReference.getVariants must not return null");
        }
        return lookupElementArray;
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange;
    }
}

