/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.introspection;

import com.intellij.lang.ant.misc.AntStringInterner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntTypeId {
    private String myName;
    private String myNsPrefix;

    public AntTypeId(@NonNls String name, @Nullable String nsPrefix) {
        this.init(name, nsPrefix);
    }

    public AntTypeId(@NonNls String name) {
        int nsSeparator = name.indexOf(58);
        if (nsSeparator < 0) {
            this.init(name, null);
        } else {
            this.init(name.substring(nsSeparator + 1), name.substring(0, nsSeparator));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AntTypeId antTypeId = (AntTypeId)o;
        if (!this.myName.equals(antTypeId.myName)) {
            return false;
        }
        return this.myNsPrefix == null || antTypeId.myNsPrefix == null || this.myNsPrefix.equals(antTypeId.myNsPrefix);
    }

    public int hashCode() {
        return 31 * this.myName.hashCode() + (this.myNsPrefix != null ? this.myNsPrefix.hashCode() : 0);
    }

    @NonNls
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getNamespacePrefix() {
        return this.myNsPrefix;
    }

    private void init(@NonNls String name, @Nullable String nsPrefix) {
        this.myName = AntStringInterner.intern(name);
        this.myNsPrefix = nsPrefix != null && nsPrefix.length() > 0 ? AntStringInterner.intern(nsPrefix) : null;
    }
}

