/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.PatternBasedInjectionHelper;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeInjection
extends AbstractTagInjection {
    @NotNull
    @NonNls
    private StringMatcher myAttributeNameMatcher = StringMatcher.NONE;
    @NotNull
    @NonNls
    private String myAttributeNamespace = "";

    @NotNull
    public String getAttributeName() {
        String string = this.myAttributeNameMatcher.getPattern();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.getAttributeName must not return null");
        }
        return string;
    }

    public void setAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.setAttributeName must not be null");
        }
        this.myAttributeNameMatcher = StringMatcher.create(attributeName);
    }

    @NotNull
    public String getAttributeNamespace() {
        String string = this.myAttributeNamespace;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.getAttributeNamespace must not return null");
        }
        return string;
    }

    public void setAttributeNamespace(@NotNull String attributeNamespace) {
        if (attributeNamespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.setAttributeNamespace must not be null");
        }
        this.myAttributeNamespace = attributeNamespace;
    }

    public boolean isApplicable(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.isApplicable must not be null");
        }
        PsiElement element = value.getParent();
        return element instanceof XmlAttribute && this.matches((XmlAttribute)element);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getDisplayName() {
        String string;
        String tag = this.getTagName();
        String attributeName = this.getAttributeName();
        if (!attributeName.equals(StringMatcher.NONE.getPattern())) {
            if (!(tag.length() > 0 ? (string = tag + "/@" + (attributeName.length() > 0 ? attributeName : "*")) != null : (string = "*/@" + (attributeName.length() > 0 ? attributeName : "*")) != null)) throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.getDisplayName must not return null");
            return string;
        }
        string = attributeName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.getDisplayName must not return null");
    }

    @Override
    protected List<String> generatePlaces() {
        return Collections.singletonList(PatternBasedInjectionHelper.getPatternString(this));
    }

    private boolean matches(@NotNull XmlAttribute attr) {
        if (attr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.matches must not be null");
        }
        boolean b = this.myAttributeNameMatcher.matches(attr.getLocalName()) && (attr.getName().indexOf(58) == -1 || this.myAttributeNamespace.equals(attr.getNamespace())) && this.matches(attr.getParent());
        return b && this.matchXPath((XmlElement)attr);
    }

    @Override
    public XmlAttributeInjection copy() {
        return new XmlAttributeInjection().copyFrom(this);
    }

    @Override
    public XmlAttributeInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection.copyFrom must not be null");
        }
        super.copyFrom(o);
        if (o instanceof XmlAttributeInjection) {
            XmlAttributeInjection other = (XmlAttributeInjection)o;
            this.setAttributeName(other.getAttributeName());
            this.setAttributeNamespace(other.getAttributeNamespace());
        }
        return this;
    }

    @Override
    protected void readExternalImpl(Element e) {
        super.readExternalImpl(e);
        if (e.getAttribute("injector-id") == null) {
            this.setAttributeName(JDOMExternalizer.readString((Element)e, (String)"ATT_NAME"));
            this.setAttributeNamespace(JDOMExternalizer.readString((Element)e, (String)"ATT_NAMESPACE"));
        }
    }

    @Override
    protected void writeExternalImpl(Element e) {
        super.writeExternalImpl(e);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XmlAttributeInjection that = (XmlAttributeInjection)o;
        if (!this.myAttributeNameMatcher.getPattern().equals(that.myAttributeNameMatcher.getPattern())) {
            return false;
        }
        return this.myAttributeNamespace.equals(that.myAttributeNamespace);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAttributeNameMatcher.getPattern().hashCode();
        result = 31 * result + this.myAttributeNamespace.hashCode();
        return result;
    }
}

