/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.InjectionPanel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInjectionPanel<T extends BaseInjection>
implements InjectionPanel<T> {
    private final List<Field> myOtherPanels;
    private final List<Runnable> myUpdaters;
    protected final Project myProject;
    @NotNull
    protected final T myOrigInjection;
    private T myEditCopy;

    protected AbstractInjectionPanel(@NotNull T injection, @NotNull Project project) {
        Field[] declaredFields;
        if (injection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/ui/AbstractInjectionPanel.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/ui/AbstractInjectionPanel.<init> must not be null");
        }
        this.myOtherPanels = new ArrayList<Field>(3);
        this.myUpdaters = new ArrayList<Runnable>(1);
        this.myOrigInjection = injection;
        this.myProject = project;
        for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
            if (!InjectionPanel.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            this.myOtherPanels.add(field);
        }
    }

    @Override
    public final T getInjection() {
        this.apply(this.myEditCopy);
        return this.myEditCopy;
    }

    @Override
    public final void init(@NotNull T copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/intellij/plugins/intelliLang/inject/config/ui/AbstractInjectionPanel.init must not be null");
        }
        this.myEditCopy = copy;
        for (Field panel : this.myOtherPanels) {
            InjectionPanel p = this.getField(panel);
            p.init(copy);
        }
        this.reset();
    }

    @Override
    public final boolean isModified() {
        this.apply(this.myEditCopy);
        for (Field panel : this.myOtherPanels) {
            InjectionPanel p = this.getField(panel);
            p.isModified();
        }
        return !((BaseInjection)this.myEditCopy).equals(this.myOrigInjection);
    }

    @Override
    public final void apply() {
        this.apply(this.myOrigInjection);
        for (Field panel : this.myOtherPanels) {
            this.getField(panel).apply();
        }
        ((BaseInjection)this.myEditCopy).copyFrom((BaseInjection)this.myOrigInjection);
    }

    protected abstract void apply(T var1);

    @Override
    public final void reset() {
        for (Field panel : this.myOtherPanels) {
            this.getField(panel).reset();
        }
        ((BaseInjection)this.myEditCopy).copyFrom((BaseInjection)this.myOrigInjection);
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractInjectionPanel.this.resetImpl();
            }
        });
    }

    protected abstract void resetImpl();

    @Override
    public void addUpdater(Runnable updater) {
        this.myUpdaters.add(updater);
        for (Field panel : this.myOtherPanels) {
            InjectionPanel field = this.getField(panel);
            field.addUpdater(updater);
        }
    }

    private InjectionPanel getField(Field field) {
        try {
            return (InjectionPanel)field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    protected void updateTree() {
        this.apply(this.myEditCopy);
        for (Runnable updater : this.myUpdaters) {
            updater.run();
        }
    }

    protected class TreeUpdateListener
    extends DocumentAdapter {
        protected TreeUpdateListener() {
        }

        public void documentChanged(DocumentEvent e) {
            AbstractInjectionPanel.this.updateTree();
        }
    }
}

