/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Consumer;
import com.intellij.util.LocalTimeCounter;
import org.intellij.plugins.intelliLang.util.ShiftTabAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    private final Language myLanguage;
    private final Project myProject;

    public LanguageTextField(Language language, @NotNull Project project, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/util/LanguageTextField.<init> must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/plugins/intelliLang/util/LanguageTextField.<init> must not be null");
        }
        this(language, project, value, null);
    }

    public LanguageTextField(@Nullable Language language, @NotNull Project project, @NotNull String value, @Nullable Consumer<PsiFile> tagger) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/intellij/plugins/intelliLang/util/LanguageTextField.<init> must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/intellij/plugins/intelliLang/util/LanguageTextField.<init> must not be null");
        }
        super(LanguageTextField.createDocument(value, language, project, tagger), project, (FileType)(language != null ? language.getAssociatedFileType() : StdFileTypes.PLAIN_TEXT), language == null);
        this.myLanguage = language;
        this.myProject = project;
        this.setEnabled(language != null);
        ShiftTabAction.attachTo(this);
    }

    private static Document createDocument(String value, @Nullable Language language, Project project, @Nullable Consumer<PsiFile> tagger) {
        if (language != null) {
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
            FileType fileType = language.getAssociatedFileType();
            assert (fileType != null);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = factory.createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)value, stamp, true, false);
            if (tagger != null) {
                tagger.consume((Object)psiFile);
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            assert (document != null);
            return document;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)value);
    }

    protected EditorEx createEditor() {
        EditorEx ex = super.createEditor();
        if (this.myLanguage != null) {
            FileType fileType = this.myLanguage.getAssociatedFileType();
            ex.setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (FileType)fileType));
        }
        ex.setEmbeddedIntoDialogWrapper(true);
        return ex;
    }
}

