/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PackageScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestPackage
extends TestObject {
    private static BackgroundableProcessIndicator mySearchForTestsIndicator;

    public TestPackage(Project project, JUnitConfiguration configuration, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        super(project, configuration, runnerSettings, configurationSettings);
    }

    @Override
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.myConfiguration);
    }

    @Override
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/junit/TestPackage.execute must not be null");
        }
        try {
            return super.execute(executor, runner);
        }
        catch (ExecutionException e) {
            if (mySearchForTestsIndicator != null && !mySearchForTestsIndicator.isCanceled()) {
                mySearchForTestsIndicator.cancel();
            }
            throw e;
        }
    }

    @Override
    protected void initialize() throws ExecutionException {
        super.initialize();
        Project project = this.myConfiguration.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        final String packageName = data.getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw CantRunException.packageNotFound((String)packageName);
        }
        TestClassFilter filter = this.getClassFilter(aPackage);
        final ExecutionException[] exception = new ExecutionException[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    TestPackage.this.myConfiguration.configureClasspath(TestPackage.this.myJavaParameters);
                }
                catch (CantRunException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        try {
            this.myTempFile = File.createTempFile("idea_junit", ".tmp");
            this.myTempFile.deleteOnExit();
            this.myJavaParameters.getProgramParametersList().add("@" + this.myTempFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            this.myJavaParameters.getProgramParametersList().add("-socket" + serverSocket.getLocalPort());
            TestPackage.findTestsWithProgress(new FindCallback(){

                @Override
                public void found(@NotNull Collection<PsiClass> classes, boolean isJunit4) {
                    if (classes == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/TestPackage$2.found must not be null");
                    }
                    TestPackage.this.addClassesListToJavaParameters(classes, new Function<PsiElement, String>(){

                        @Nullable
                        public String fun(PsiElement element) {
                            if (element instanceof PsiClass) {
                                return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element));
                            }
                            if (element instanceof PsiMethod) {
                                PsiMethod method = (PsiMethod)element;
                                return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)method.getContainingClass()) + "," + method.getName();
                            }
                            return null;
                        }
                    }, packageName, false, isJunit4);
                }
            }, filter, serverSocket);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private TestClassFilter getClassFilter(PsiPackage aPackage) throws JUnitUtil.NoJUnitException {
        Module module = ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).getModule();
        if (this.myConfiguration.getPersistentData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            module = null;
        }
        TestClassFilter classFilter = TestClassFilter.create(this.getSourceScope(), module);
        return classFilter.intersectionWith(PackageScope.packageScope((PsiPackage)aPackage, (boolean)true));
    }

    @Override
    public String suggestActionName() {
        String configurationName = this.myConfiguration.getName();
        if (!this.myConfiguration.isGeneratedName()) {
            return "'" + configurationName + "'";
        }
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        if (data.getPackageName().trim().length() > 0) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{data.getPackageName()});
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        if (!(element instanceof PsiPackage)) {
            return null;
        }
        return RefactoringListeners.getListener((PsiPackage)((PsiPackage)element), configuration.myPackage);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiElement element) {
        PsiPackage aPackage;
        if (element instanceof PsiPackage) {
            aPackage = (PsiPackage)element;
        } else if (element instanceof PsiDirectory) {
            aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element);
        } else {
            return false;
        }
        return aPackage != null && Comparing.equal((String)aPackage.getQualifiedName(), (String)configuration.getPersistentData().getPackageName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String packageName = this.myConfiguration.getPersistentData().getPackageName();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myConfiguration.getProject()).findPackage(packageName);
        if (aPackage == null) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{packageName}));
        }
        if (this.getSourceScope() == null) {
            ((JavaRunConfigurationModule)this.myConfiguration.getConfigurationModule()).checkForWarning();
        }
    }

    private static void findTestsWithProgress(final FindCallback callback, final TestClassFilter classFilter, final ServerSocket serverSocket) {
        if (TestPackage.isSyncSearch()) {
            THashSet classes = new THashSet();
            boolean isJUnit4 = ConfigurationUtil.findAllTestClasses(classFilter, (Set<PsiClass>)classes);
            callback.found((Collection<PsiClass>)classes, isJUnit4);
            return;
        }
        final THashSet classes = new THashSet();
        final boolean[] isJunit4 = new boolean[1];
        Task.Backgroundable task = new Task.Backgroundable(classFilter.getProject(), ExecutionBundle.message((String)"seaching.test.progress.title", (Object[])new Object[0]), true){
            private Socket mySocket;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit/TestPackage$3.run must not be null");
                }
                try {
                    this.mySocket = serverSocket.accept();
                }
                catch (IOException e) {
                    TestObject.LOG.info((Throwable)e);
                }
                isJunit4[0] = ConfigurationUtil.findAllTestClasses(classFilter, (Set<PsiClass>)classes);
            }

            public void onSuccess() {
                callback.found((Collection<PsiClass>)classes, isJunit4[0]);
                this.connect();
            }

            public void onCancel() {
                this.connect();
            }

            public DumbModeAction getDumbModeAction() {
                return DumbModeAction.WAIT;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void connect() {
                DataOutputStream os = null;
                try {
                    os = new DataOutputStream(this.mySocket.getOutputStream());
                    os.writeBoolean(true);
                }
                catch (Throwable e) {
                    TestObject.LOG.info(e);
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (Throwable e) {
                        TestObject.LOG.info(e);
                    }
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable e) {
                        TestObject.LOG.info(e);
                    }
                }
            }
        };
        mySearchForTestsIndicator = new BackgroundableProcessIndicator(task){

            public void cancel() {
                try {
                    if (!serverSocket.isClosed()) {
                        new Socket(InetAddress.getLocalHost(), serverSocket.getLocalPort());
                    }
                }
                catch (Throwable e) {
                    TestObject.LOG.info(e);
                }
                super.cancel();
            }
        };
        ProgressManagerImpl.runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)mySearchForTestsIndicator);
    }

    private static boolean isSyncSearch() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    public static interface FindCallback {
        public void found(@NotNull Collection<PsiClass> var1, boolean var2);
    }
}

