/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FilterCache {
    private final ArrayList<TestProxy> myList = new ArrayList(4);
    private final Set<TestProxy> mySet = new HashSet<TestProxy>();
    private final Map<Filter, ArrayList<TestProxy>> myCache = new THashMap();

    FilterCache() {
    }

    public TestProxy[] select(Filter filter) {
        ArrayList<TestProxy> selected = this.selectImpl(filter);
        return selected.toArray(new TestProxy[selected.size()]);
    }

    public List<TestProxy> getList() {
        return this.myList;
    }

    public void resetCache() {
        this.myCache.clear();
    }

    public List<TestProxy> getUnmodifiableList() {
        return Collections.unmodifiableList(this.myList);
    }

    public void add(TestProxy test) {
        this.myList.add(test);
        this.mySet.add(test);
        this.resetCache();
    }

    public boolean contains(TestProxy test) {
        return this.mySet.contains((Object)test);
    }

    public AbstractTestProxy detect(Filter filter) {
        return filter.detectIn(this.myList);
    }

    public Iterator iterator() {
        return this.myList.iterator();
    }

    private ArrayList<TestProxy> selectImpl(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/junit2/FilterCache.selectImpl must not be null");
        }
        ArrayList<TestProxy> result = this.myCache.get(filter);
        if (result != null) {
            return result;
        }
        ArrayList<TestProxy> selected = new ArrayList<TestProxy>();
        for (TestProxy childTest : this.myList) {
            if (!filter.shouldAccept((AbstractTestProxy)childTest)) continue;
            selected.add(childTest);
        }
        selected.trimToSize();
        this.myCache.put(filter, selected);
        return selected;
    }
}

