/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import com.siyeh.ig.ui.ToggleAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IgnoreResultOfCallInspection
extends BaseInspection {
    public boolean m_reportAllNonLibraryCalls = false;
    @NonNls
    public String callCheckString = "java.io.InputStream,read,java.io.InputStream,skip,java.lang.StringBuffer,toString,java.lang.StringBuilder,toString,java.lang.String,.*,java.math.BigInteger,.*,java.math.BigDecimal,.*,java.net.InetAddress,.*,java.io.File,.*,java.lang.Object,equals|hashCode";
    final List<String> methodNamePatterns = new ArrayList<String>();
    final List<String> classNames = new ArrayList<String>();
    Map<String, Pattern> patternCache = null;

    public IgnoreResultOfCallInspection() {
        IgnoreResultOfCallInspection.parseString(this.callCheckString, this.classNames, this.methodNamePatterns);
    }

    @NotNull
    public String getID() {
        if ("ResultOfMethodCallIgnored" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IgnoreResultOfCallInspection.getID must not return null");
        }
        return "ResultOfMethodCallIgnored";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IgnoreResultOfCallInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass containingClass = (PsiClass)infos[0];
        String className = containingClass.getName();
        String string = InspectionGadgetsBundle.message("result.of.method.call.ignored.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/IgnoreResultOfCallInspection.buildErrorString must not return null");
        }
        return string;
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        IgnoreResultOfCallInspection.parseString(this.callCheckString, this.classNames, this.methodNamePatterns);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.callCheckString = IgnoreResultOfCallInspection.formatString(this.classNames, this.methodNamePatterns);
        super.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IgnoreResultOfCallVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        IGTable table;
        JCheckBox nonLibraryCheckbox;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
            this.nonLibraryCheckbox.setAction(new ToggleAction(InspectionGadgetsBundle.message("result.of.method.call.ignored.non.library.option", new Object[0]), IgnoreResultOfCallInspection.this, "m_reportAllNonLibraryCalls"));
            this.nonLibraryCheckbox.setSelected(IgnoreResultOfCallInspection.this.m_reportAllNonLibraryCalls);
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(Arrays.asList(IgnoreResultOfCallInspection.this.classNames, IgnoreResultOfCallInspection.this.methodNamePatterns), InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("result.of.method.call.ignored.method.column.title", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.add"));
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.remove"));
            jButton.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.nonLibraryCheckbox = jCheckBox = new JCheckBox();
            jCheckBox.setAutoscrolls(true);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("result.of.method.call.ignored.non.library.option"));
            jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class IgnoreResultOfCallVisitor
    extends BaseInspectionVisitor {
        private IgnoreResultOfCallVisitor() {
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/IgnoreResultOfCallInspection$IgnoreResultOfCallVisitor.visitExpressionStatement must not be null");
            }
            super.visitExpressionStatement(statement);
            PsiExpression expression = statement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiMethod method = call.resolveMethod();
            if (method == null || method.isConstructor()) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (PsiType.VOID.equals(returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (IgnoreResultOfCallInspection.this.m_reportAllNonLibraryCalls && !LibraryUtil.classIsInLibrary(aClass)) {
                this.registerMethodCallError(call, aClass);
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            for (int i = 0; i < IgnoreResultOfCallInspection.this.methodNamePatterns.size(); ++i) {
                String className;
                String methodNamePattern = IgnoreResultOfCallInspection.this.methodNamePatterns.get(i);
                if (!this.methodNamesMatch(methodName, methodNamePattern) || !ClassUtils.isSubclass(aClass, className = IgnoreResultOfCallInspection.this.classNames.get(i))) continue;
                this.registerMethodCallError(call, aClass);
                return;
            }
        }

        private boolean methodNamesMatch(String methodName, String methodNamePattern) {
            Pattern pattern;
            if (IgnoreResultOfCallInspection.this.patternCache != null) {
                pattern = IgnoreResultOfCallInspection.this.patternCache.get(methodNamePattern);
            } else {
                IgnoreResultOfCallInspection.this.patternCache = new HashMap<String, Pattern>(IgnoreResultOfCallInspection.this.methodNamePatterns.size());
                pattern = null;
            }
            if (pattern == null) {
                try {
                    pattern = Pattern.compile(methodNamePattern);
                    IgnoreResultOfCallInspection.this.patternCache.put(methodNamePattern, pattern);
                }
                catch (PatternSyntaxException ignore) {
                    return false;
                }
                catch (NullPointerException ignore) {
                    return false;
                }
            }
            if (pattern == null) {
                return false;
            }
            Matcher matcher = pattern.matcher(methodName);
            return matcher.matches();
        }
    }
}

