/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MarkerInterfaceInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("marker.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MarkerInterfaceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("marker.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/MarkerInterfaceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MarkerInterfaceVisitor();
    }

    private static class MarkerInterfaceVisitor
    extends BaseInspectionVisitor {
        private MarkerInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/MarkerInterfaceInspection$MarkerInterfaceVisitor.visitClass must not be null");
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length != 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length != 0) {
                return;
            }
            PsiClassType[] extendsList = aClass.getExtendsListTypes();
            if (extendsList.length > 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

