/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CloneableImplementsCloneInspection
extends BaseInspection {
    public boolean m_ignoreCloneableDueToInheritance = false;

    @NotNull
    public String getID() {
        if ("CloneableClassWithoutClone" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneableImplementsCloneInspection.getID must not return null");
        }
        return "CloneableClassWithoutClone";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneableImplementsCloneInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/cloneable/CloneableImplementsCloneInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cloneable.class.without.clone.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCloneableDueToInheritance");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableDefinesCloneVisitor();
    }

    private class CloneableDefinesCloneVisitor
    extends BaseInspectionVisitor {
        private CloneableDefinesCloneVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/cloneable/CloneableImplementsCloneInspection$CloneableDefinesCloneVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (CloneableImplementsCloneInspection.this.m_ignoreCloneableDueToInheritance ? !CloneUtils.isDirectlyCloneable(aClass) : !CloneUtils.isCloneable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!CloneUtils.isClone(method)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

