/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class OverridableMethodCallDuringObjectConstructionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overridable.method.call.in.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overridable.method.call.in.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.buildErrorString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        PsiClass callClass = ClassUtils.getContainingClass((PsiElement)methodCallExpression);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            inspectionGadgetsFixArray = InspectionGadgetsFix.EMPTY_ARRAY;
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        PsiClass containingClass = method.getContainingClass();
        if (!containingClass.equals(callClass) || MethodUtils.isOverridden(method)) {
            inspectionGadgetsFixArray = InspectionGadgetsFix.EMPTY_ARRAY;
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        String methodName = method.getName();
        if (!ClassUtils.isOverridden(containingClass)) {
            inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MakeClassFinalFix(containingClass), new MakeMethodFinalFix(methodName)};
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new MakeMethodFinalFix(methodName)};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection.buildFixes must not return null");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverridableMethodCallInConstructorVisitor();
    }

    private static class OverridableMethodCallInConstructorVisitor
    extends BaseInspectionVisitor {
        private OverridableMethodCallInConstructorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression;
            PsiExpression qualifier;
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$OverridableMethodCallInConstructorVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)call, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class});
            if (member instanceof PsiClassInitializer) {
                PsiClassInitializer classInitializer = (PsiClassInitializer)member;
                if (classInitializer.hasModifierProperty("static")) {
                    return;
                }
            } else if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (!OverridableMethodCallInConstructorVisitor.isObjectConstructionMethod(method)) {
                    return;
                }
            } else {
                return;
            }
            if ((qualifier = (methodExpression = call.getMethodExpression()).getQualifierExpression()) != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                return;
            }
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("final")) {
                return;
            }
            PsiMethod calledMethod = (PsiMethod)methodExpression.resolve();
            if (calledMethod == null || !PsiUtil.canBeOverriden((PsiMethod)calledMethod)) {
                return;
            }
            PsiClass calledMethodClass = calledMethod.getContainingClass();
            if (calledMethodClass == null || !calledMethodClass.equals(containingClass)) {
                return;
            }
            this.registerMethodCallError(call, call);
        }

        public static boolean isObjectConstructionMethod(PsiMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            if (CloneUtils.isClone(method)) {
                return true;
            }
            if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                return true;
            }
            return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
        }
    }

    private static class MakeMethodFinalFix
    extends InspectionGadgetsFix {
        private final String methodName;

        MakeMethodFinalFix(String methodName) {
            this.methodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.method.final.fix.name", this.methodName);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$MakeMethodFinalFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiElement methodExpression = methodName.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiMethod method = methodCall.resolveMethod();
            assert (method != null);
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("final", true);
        }
    }

    private static class MakeClassFinalFix
    extends InspectionGadgetsFix {
        private final String className;

        MakeClassFinalFix(PsiClass aClass) {
            this.className = aClass.getName();
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("make.class.final.fix.name", this.className);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/initialization/OverridableMethodCallDuringObjectConstructionInspection$MakeClassFinalFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiModifierList modifierList = containingClass.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("final", true);
        }
    }
}

