/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeOrAfterIsPublicVoidNoArgInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection.getID must not return null");
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.or.after.is.public.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeOrAfterIsPublicVoidNoArgVisitor();
    }

    private static class BeforeOrAfterIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeOrAfterIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/BeforeOrAfterIsPublicVoidNoArgInspection$BeforeOrAfterIsPublicVoidNoArgVisitor.visitMethod must not be null");
            }
            if (!TestUtils.isJUnit4BeforeOrAfterMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                this.registerMethodError(method, new Object[0]);
            } else if (!returnType.equals(PsiType.VOID)) {
                this.registerMethodError(method, new Object[0]);
            } else if (!method.hasModifierProperty("public")) {
                this.registerMethodError(method, new Object[0]);
            } else if (method.hasModifierProperty("static")) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

