/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.CallToSuperTeardownVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class TeardownCallsSuperTeardownInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("TearDownDoesntCallSuperTearDown" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection.getID must not return null");
        }
        return "TearDownDoesntCallSuperTearDown";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSuperTearDownCall();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TeardownCallsSuperTeardownVisitor();
    }

    private static class TeardownCallsSuperTeardownVisitor
    extends BaseInspectionVisitor {
        private TeardownCallsSuperTeardownVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$TeardownCallsSuperTeardownVisitor.visitMethod must not be null");
            }
            String methodName = method.getName();
            if (!"tearDown".equals(methodName)) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                return;
            }
            if (method.getBody() == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(targetClass, "junit.framework.TestCase")) {
                return;
            }
            CallToSuperTeardownVisitor visitor = new CallToSuperTeardownVisitor();
            method.accept((PsiElementVisitor)visitor);
            if (visitor.isCallToSuperTeardownFound()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }

    private static class AddSuperTearDownCall
    extends InspectionGadgetsFix {
        private AddSuperTearDownCall() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("teardown.calls.super.teardown.add.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/TeardownCallsSuperTeardownInspection$AddSuperTearDownCall.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            if (method == null) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            PsiStatement newStatement = factory.createStatementFromText("super.tearDown();", null);
            CodeStyleManager styleManager = psiManager.getCodeStyleManager();
            PsiJavaToken brace = body.getRBrace();
            body.addBefore((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body);
        }
    }
}

