/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.CyclomaticComplexityVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        if ("OverlyComplexMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection.getID must not return null");
        }
        return "OverlyComplexMethod";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cyclomatic.complexity.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer complexity = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("cyclomatic.complexity.problem.descriptor", complexity);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodComplexityVisitor();
    }

    private class MethodComplexityVisitor
    extends BaseInspectionVisitor {
        private MethodComplexityVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/CyclomaticComplexityInspection$MethodComplexityVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CyclomaticComplexityVisitor visitor = new CyclomaticComplexityVisitor();
            method.accept((PsiElementVisitor)visitor);
            int complexity = visitor.getComplexity();
            if (complexity <= CyclomaticComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, complexity);
        }
    }
}

