/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BooleanMethodNameMustStartWithQuestionInspection
extends BaseInspection {
    @NonNls
    public String questionString = "is,can,has,should,could,will,shall,check,contains,equals,add,put,remove,startsWith,endsWith";
    List<String> questionList = new ArrayList<String>(32);

    public BooleanMethodNameMustStartWithQuestionInspection() {
        BooleanMethodNameMustStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        BooleanMethodNameMustStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.questionString = BooleanMethodNameMustStartWithQuestionInspection.formatString(this.questionList);
        super.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanMethodNameMustStartWithQuestionVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        IGTable table;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(BooleanMethodNameMustStartWithQuestionInspection.this.questionList, InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.table.column.name", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 3, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.add"));
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.remove"));
            jButton.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class BooleanMethodNameMustStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private BooleanMethodNameMustStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/BooleanMethodNameMustStartWithQuestionInspection$BooleanMethodNameMustStartWithQuestionVisitor.visitMethod must not be null");
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null || !returnType.equals(PsiType.BOOLEAN)) {
                return;
            }
            String name = method.getName();
            for (String question : BooleanMethodNameMustStartWithQuestionInspection.this.questionList) {
                if (!name.startsWith(question)) continue;
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

