/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class QuestionableNameInspection
extends BaseInspection {
    @NonNls
    public String nameString = "aa,abc,bad,bar,bar2,baz,baz1,baz2,baz3,bb,blah,bogus,bool,cc,dd,defau1t,dummy,dummy2,ee,fa1se,ff,foo,foo1,foo2,foo3,foobar,four,fred,fred1,fred2,gg,hh,hello,hello1,hello2,hello3,ii,nu11,one,silly,silly2,string,two,that,then,three,whi1e,var";
    List<String> nameList = new ArrayList<String>(32);

    public QuestionableNameInspection() {
        QuestionableNameInspection.parseString(this.nameString, this.nameList);
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("questionable.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/QuestionableNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("questionable.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/QuestionableNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        QuestionableNameInspection.parseString(this.nameString, this.nameList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.nameString = QuestionableNameInspection.formatString(this.nameList);
        super.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new QuestionableNameVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        IGTable table;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(QuestionableNameInspection.this.nameList, InspectionGadgetsBundle.message("questionable.name.column.title", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 3, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.add"));
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.remove"));
            jButton.setMargin(new Insets(3, 8, 3, 8));
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class QuestionableNameVisitor
    extends BaseInspectionVisitor {
        private final Set<String> nameSet;

        private QuestionableNameVisitor() {
            this.nameSet = new HashSet<String>(QuestionableNameInspection.this.nameList);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/QuestionableNameInspection$QuestionableNameVisitor.visitVariable must not be null");
            }
            String name = variable.getName();
            if (this.nameSet.contains(name)) {
                this.registerVariableError(variable, new Object[0]);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/QuestionableNameInspection$QuestionableNameVisitor.visitMethod must not be null");
            }
            String name = method.getName();
            if (this.nameSet.contains(name)) {
                this.registerMethodError(method, new Object[0]);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/QuestionableNameInspection$QuestionableNameVisitor.visitClass must not be null");
            }
            String name = aClass.getName();
            if (this.nameSet.contains(name)) {
                this.registerClassError(aClass, new Object[0]);
            }
        }
    }
}

