/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class ConvertOctalLiteralToDecimalFix
extends InspectionGadgetsFix {
    ConvertOctalLiteralToDecimalFix() {
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("convert.octal.literal.to.decimal.literal.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/ConvertOctalLiteralToDecimalFix.getName must not return null");
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        String text = element.getText();
        int number = Integer.parseInt(text, 8);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression decimalNumber = factory.createExpressionFromText(Integer.toString(number), element);
        element.replace((PsiElement)decimalNumber);
    }
}

