/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInLoopsInspection
extends BaseInspection {
    public boolean m_ignoreUnlessAssigned = true;

    @NotNull
    public String getID() {
        if ("StringContatenationInLoop" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInLoopsInspection.getID must not return null");
        }
        return "StringContatenationInLoop";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInLoopsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.loops.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInLoopsInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.concatenation.in.loops.only.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreUnlessAssigned");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInLoopsVisitor();
    }

    private class StringConcatenationInLoopsVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInLoopsVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUS)) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            if (!ControlFlowUtils.isInLoop((PsiElement)expression)) {
                return;
            }
            if (ControlFlowUtils.isInExitStatement((PsiExpression)expression)) {
                return;
            }
            if (ExpressionUtils.isEvaluatedAtCompileTime((PsiExpression)expression)) {
                return;
            }
            if (this.containingStatementExits((PsiElement)expression)) {
                return;
            }
            if (StringConcatenationInLoopsInspection.this.m_ignoreUnlessAssigned && !this.isAppendedRepeatedly((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)sign, new Object[0]);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringConcatenationInLoopsInspection$StringConcatenationInLoopsVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSEQ)) {
                return;
            }
            PsiExpression lhs = expression.getLExpression();
            PsiType type = lhs.getType();
            if (type == null) {
                return;
            }
            if (!TypeUtils.isJavaLangString(type)) {
                return;
            }
            if (!ControlFlowUtils.isInLoop((PsiElement)expression)) {
                return;
            }
            if (ControlFlowUtils.isInExitStatement((PsiExpression)expression)) {
                return;
            }
            if (this.containingStatementExits((PsiElement)expression)) {
                return;
            }
            if (StringConcatenationInLoopsInspection.this.m_ignoreUnlessAssigned) {
                while (lhs instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)lhs;
                    lhs = parenthesizedExpression.getExpression();
                }
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
            }
            this.registerError((PsiElement)sign, new Object[0]);
        }

        private boolean containingStatementExits(PsiElement element) {
            PsiStatement newExpressionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
            if (newExpressionStatement == null) {
                return this.containingStatementExits(element);
            }
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            return !ControlFlowUtils.statementMayCompleteNormally(parentStatement);
        }

        private boolean isAppendedRepeatedly(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiBinaryExpression) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            while (lhs instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)lhs;
                lhs = parenthesizedExpression.getExpression();
            }
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            if (assignmentExpression.getOperationTokenType() == JavaTokenType.PLUSEQ) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)element;
            PsiExpression rhs = assignmentExpression.getRExpression();
            return rhs != null && VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs);
        }
    }
}

