/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VariableIsModifiedVisitor
extends JavaRecursiveElementVisitor {
    @NonNls
    private static final Set<String> updateNames = new HashSet<String>(9);
    private boolean modified = false;
    private final PsiVariable variable;

    VariableIsModifiedVisitor(PsiVariable variable) {
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/VariableIsModifiedVisitor.visitElement must not be null");
        }
        if (!this.modified) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/VariableIsModifiedVisitor.visitMethodCallExpression must not be null");
        }
        if (this.modified) {
            return;
        }
        super.visitMethodCallExpression(call);
        if (!VariableIsModifiedVisitor.isStringBufferUpdate(call)) {
            return;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)qualifier;
        PsiElement referent = reference.resolve();
        if (this.variable.equals(referent)) {
            this.modified = true;
        }
    }

    public static boolean isStringBufferUpdate(@Nullable PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        return updateNames.contains(methodName);
    }

    public boolean isModified() {
        return this.modified;
    }

    static {
        updateNames.add("append");
        updateNames.add("appendCodePoint");
        updateNames.add("delete");
        updateNames.add("deleteCharAt");
        updateNames.add("insert");
        updateNames.add("replace");
        updateNames.add("reverse");
        updateNames.add("setCharAt");
        updateNames.add("setLength");
    }
}

