/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NativeMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NativeMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/NativeMethodsInspection.getID must not return null");
        }
        return "NativeMethod";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("native.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/NativeMethodsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("native.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/NativeMethodsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NativeMethodVisitor();
    }

    private static class NativeMethodVisitor
    extends BaseInspectionVisitor {
        private NativeMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/NativeMethodsInspection$NativeMethodVisitor.visitMethod must not be null");
            }
            if (!method.hasModifierProperty("native")) {
                return;
            }
            this.registerModifierError("native", (PsiModifierListOwner)method, new Object[0]);
        }
    }
}

