/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import org.jetbrains.annotations.NotNull;

public class MultipleDeclarationInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.declaration.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleDeclarationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("MultipleVariablesInDeclaration" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleDeclarationInspection.getID must not return null");
        }
        return "MultipleVariablesInDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.declaration.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/MultipleDeclarationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleDeclarationVisitor();
    }

    private static class MultipleDeclarationVisitor
    extends BaseInspectionVisitor {
        private MultipleDeclarationVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            PsiForStatement forStatement;
            PsiStatement initialization;
            super.visitDeclarationStatement(statement);
            if (statement.getDeclaredElements().length <= 1) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiForStatement && statement.equals(initialization = (forStatement = (PsiForStatement)parent).getInitialization())) {
                return;
            }
            PsiElement[] declaredVars = statement.getDeclaredElements();
            for (int i = 1; i < declaredVars.length; ++i) {
                PsiLocalVariable var = (PsiLocalVariable)declaredVars[i];
                this.registerVariableError((PsiVariable)var, new Object[0]);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/MultipleDeclarationInspection$MultipleDeclarationVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (MultipleDeclarationVisitor.childrenContainTypeElement((PsiElement)field)) {
                return;
            }
            if (field instanceof PsiEnumConstant) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        public static boolean childrenContainTypeElement(PsiElement field) {
            PsiElement[] children;
            for (PsiElement aChildren : children = field.getChildren()) {
                if (!(aChildren instanceof PsiTypeElement)) continue;
                return true;
            }
            return false;
        }
    }
}

