/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryConstantArrayCreationExpressionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConstantArrayCreationExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstantArrayCreationExpressionVisitor();
    }

    private static class UnnecessaryConstantArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstantArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
            super.visitArrayInitializerExpression(expression);
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)grandParent;
            if (UnnecessaryConstantArrayCreationExpressionVisitor.hasGenericTypeParameters(variable)) {
                return;
            }
            this.registerError(parent, new Object[0]);
        }

        private static boolean hasGenericTypeParameters(PsiVariable variable) {
            PsiType[] parameterTypes;
            PsiType type = variable.getType();
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)componentType;
            for (PsiType parameterType : parameterTypes = classType.getParameters()) {
                if (parameterType == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryConstantArrayCreationExpressionFix
    extends InspectionGadgetsFix {
        private UnnecessaryConstantArrayCreationExpressionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection$UnnecessaryConstantArrayCreationExpressionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return;
            }
            newExpression.replace((PsiElement)arrayInitializer);
        }
    }
}

