/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class BusyWaitInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("busy.wait.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/BusyWaitInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("busy.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/BusyWaitInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BusyWaitVisitor();
    }

    private static class BusyWaitVisitor
    extends BaseInspectionVisitor {
        private BusyWaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/BusyWaitInspection$BusyWaitVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, "java.lang.Thread", PsiType.VOID, "sleep", PsiType.LONG) && !MethodCallUtils.isCallToMethod(expression, "java.lang.Thread", PsiType.VOID, "sleep", PsiType.LONG, PsiType.INT)) {
                return;
            }
            if (!ControlFlowUtils.isInLoop((PsiElement)expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

