/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.ui.UIBundle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class Splitter
extends JPanel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.Splitter");
    @NonNls
    public static final String PROP_PROPORTION = "proportion";
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize = false;
    private final float myMinProp;
    private final float myMaxProp;
    private float myProportion;
    private final Divider myDivider;
    private JComponent mySecondComponent;
    private JComponent myFirstComponent;
    private final FocusWatcher myFocusWatcher;
    private boolean myShowDividerControls;
    private static final Rectangle myNullBounds = new Rectangle();

    public Splitter() {
        this(false);
    }

    public Splitter(boolean vertical) {
        this(vertical, 0.5f);
    }

    public Splitter(boolean vertical, float proportion) {
        this(vertical, proportion, 0.0f, 1.0f);
    }

    public Splitter(boolean vertical, float proportion, float minProp, float maxProp) {
        this.myMinProp = minProp;
        this.myMaxProp = maxProp;
        LOG.assertTrue(minProp >= 0.0f);
        LOG.assertTrue(maxProp <= 1.0f);
        LOG.assertTrue(minProp <= maxProp);
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myDivider = this.createDivider();
        this.setProportion(proportion);
        this.myDividerWidth = 7;
        this.setOpaque(false);
        super.add(this.myDivider);
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install(this);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    @Override
    public Component add(Component comp) {
        int childCount = this.getComponentCount();
        LOG.assertTrue(childCount >= 1);
        if (childCount > 3) {
            throw new IllegalStateException("" + childCount);
        }
        LOG.assertTrue(childCount <= 3);
        if (childCount == 1) {
            this.setFirstComponent((JComponent)comp);
        } else {
            this.setSecondComponent((JComponent)comp);
        }
        return comp;
    }

    public void dispose() {
        this.myFocusWatcher.deinstall(this);
    }

    protected Divider createDivider() {
        return new Divider();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.myFirstComponent != null && this.myFirstComponent.isVisible() || this.mySecondComponent != null && this.mySecondComponent.isVisible());
    }

    @Override
    public Dimension getMinimumSize() {
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstMinSize = this.myFirstComponent.getMinimumSize();
            Dimension secondMinSize = this.mySecondComponent.getMinimumSize();
            return this.getOrientation() ? new Dimension(Math.max(firstMinSize.width, secondMinSize.width), firstMinSize.height + dividerWidth + secondMinSize.height) : new Dimension(firstMinSize.width + dividerWidth + secondMinSize.width, Math.max(firstMinSize.height, secondMinSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getMinimumSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible() && !Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            int secondComponentSize;
            int firstCompontSize;
            int dividerWidth;
            Rectangle firstRect = new Rectangle();
            Rectangle dividerRect = new Rectangle();
            Rectangle secondRect = new Rectangle();
            int componentSize = this.getOrientation() ? height : width;
            if (componentSize <= (dividerWidth = this.getDividerWidth())) {
                firstCompontSize = 0;
                secondComponentSize = 0;
                dividerWidth = componentSize;
            } else {
                firstCompontSize = (int)(this.myProportion * (float)(componentSize - dividerWidth));
                int n = secondComponentSize = this.getOrientation() ? height - firstCompontSize - dividerWidth : width - firstCompontSize - dividerWidth;
                if (this.isHonorMinimumSize()) {
                    int secondMinSize;
                    int firstMinSize = this.getOrientation() ? this.myFirstComponent.getMinimumSize().height : this.myFirstComponent.getMinimumSize().width;
                    int n2 = secondMinSize = this.getOrientation() ? this.mySecondComponent.getMinimumSize().height : this.mySecondComponent.getMinimumSize().width;
                    if (firstCompontSize + secondComponentSize <= firstMinSize + secondMinSize) {
                        float propotion = (float)firstMinSize / ((float)firstMinSize + (float)secondMinSize);
                        firstCompontSize = (int)(propotion * (float)(componentSize - dividerWidth));
                        secondComponentSize = this.getOrientation() ? height - firstCompontSize - dividerWidth : width - firstCompontSize - dividerWidth;
                    } else if (firstCompontSize < firstMinSize) {
                        if (secondComponentSize - (firstMinSize - firstCompontSize) > secondMinSize) {
                            secondComponentSize -= firstMinSize - firstCompontSize;
                        }
                        firstCompontSize = firstMinSize;
                    } else if (secondComponentSize < secondMinSize) {
                        firstCompontSize -= secondMinSize - secondComponentSize;
                        secondComponentSize = secondMinSize;
                    }
                }
            }
            if (this.getOrientation()) {
                firstRect.setBounds(0, 0, width, firstCompontSize);
                dividerRect.setBounds(0, firstCompontSize, width, dividerWidth);
                secondRect.setBounds(0, firstCompontSize + dividerWidth, width, secondComponentSize);
            } else {
                firstRect.setBounds(0, 0, firstCompontSize, height);
                dividerRect.setBounds(firstCompontSize, 0, dividerWidth, height);
                secondRect.setBounds(firstCompontSize + dividerWidth, 0, secondComponentSize, height);
            }
            this.myDivider.setVisible(true);
            this.myFirstComponent.setBounds(firstRect);
            this.myDivider.setBounds(dividerRect);
            this.mySecondComponent.setBounds(secondRect);
            this.myFirstComponent.validate();
            this.mySecondComponent.validate();
        } else if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible()) {
            Splitter.hideNull(this.mySecondComponent);
            this.myDivider.setVisible(false);
            this.myFirstComponent.setBounds(0, 0, width, height);
            this.myFirstComponent.validate();
        } else if (!Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            Splitter.hideNull(this.myFirstComponent);
            this.myDivider.setVisible(false);
            this.mySecondComponent.setBounds(0, 0, width, height);
            this.mySecondComponent.validate();
        } else {
            this.myDivider.setVisible(false);
            if (this.myFirstComponent != null) {
                this.myFirstComponent.setBounds(0, 0, 0, 0);
                this.myFirstComponent.validate();
            } else {
                Splitter.hideNull(this.myFirstComponent);
            }
            if (this.mySecondComponent != null) {
                this.mySecondComponent.setBounds(0, 0, 0, 0);
                this.mySecondComponent.validate();
            } else {
                Splitter.hideNull(this.mySecondComponent);
            }
        }
        this.myDivider.doLayout();
    }

    static boolean isNull(Component component) {
        return NullableComponent.Check.isNull(component);
    }

    static void hideNull(Component component) {
        if (component instanceof NullableComponent && !component.getBounds().equals(myNullBounds)) {
            component.setBounds(myNullBounds);
            component.validate();
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.doLayout();
            this.repaint();
        }
    }

    public float getProportion() {
        return this.myProportion;
    }

    public void setProportion(float proportion) {
        if (this.myProportion == proportion) {
            return;
        }
        if (proportion < 0.0f || proportion > 1.0f) {
            throw new IllegalArgumentException("Wrong proportion: " + proportion);
        }
        if (proportion < this.myMinProp) {
            proportion = this.myMinProp;
        }
        if (proportion > this.myMaxProp) {
            proportion = this.myMaxProp;
        }
        float oldProportion = this.myProportion;
        this.myProportion = proportion;
        this.firePropertyChange(PROP_PROPORTION, new Float(oldProportion), new Float(this.myProportion));
        this.doLayout();
        this.repaint();
    }

    public void swapComponents() {
        JComponent tmp = this.myFirstComponent;
        this.myFirstComponent = this.mySecondComponent;
        this.mySecondComponent = tmp;
        this.doLayout();
        this.repaint();
    }

    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public void setOrientation(boolean verticalSplit) {
        this.myVerticalSplit = verticalSplit;
        this.myDivider.setOrientation(verticalSplit);
        this.doLayout();
        this.repaint();
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
                this.myFirstComponent.invalidate();
            }
        }
    }

    public JComponent getSecondComponent() {
        return this.mySecondComponent;
    }

    public JComponent getOtherComponent(Component comp) {
        if (comp.equals(this.getFirstComponent())) {
            return this.getSecondComponent();
        }
        if (comp.equals(this.getSecondComponent())) {
            return this.getFirstComponent();
        }
        LOG.error("invalid component");
        return this.getFirstComponent();
    }

    public void setSecondComponent(JComponent component) {
        if (this.mySecondComponent != component) {
            if (this.mySecondComponent != null) {
                this.remove(this.mySecondComponent);
            }
            this.mySecondComponent = component;
            if (this.mySecondComponent != null) {
                super.add(this.mySecondComponent);
                this.mySecondComponent.invalidate();
            }
        }
    }

    public JPanel getDivider() {
        return this.myDivider;
    }

    protected class Divider
    extends JPanel {
        protected boolean myDragging;
        protected Point myPoint;

        public Divider() {
            super(new GridBagLayout());
            this.setFocusable(false);
            this.enableEvents(48L);
            this.setOrientation(Splitter.this.myVerticalSplit);
        }

        private void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            if (!Splitter.this.myShowDividerControls) {
                return;
            }
            int xMask = isVerticalSplit ? 1 : 0;
            int yMask = isVerticalSplit ? 0 : 1;
            Icon glueIcon = IconLoader.getIcon(isVerticalSplit ? "/general/splitGlueV.png" : "/general/splitGlueH.png");
            int glueFill = isVerticalSplit ? 3 : 2;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, isVerticalSplit ? 13 : 11, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitDownlabel = new JLabel(IconLoader.getIcon(isVerticalSplit ? "/general/splitDown.png" : "/general/splitRight.png"));
            splitDownlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitDownlabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.down.tooltip.text", new Object[0]) : UIBundle.message("splitter.right.tooltip.text", new Object[0]));
            splitDownlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Splitter.this.setProportion(1.0f - Divider.this.getMinProportion(Splitter.this.mySecondComponent));
                }
            });
            this.add((Component)splitDownlabel, new GridBagConstraints(isVerticalSplit ? 1 : 0, isVerticalSplit ? 0 : 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(2 * xMask, 2 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitCenterlabel = new JLabel(IconLoader.getIcon(isVerticalSplit ? "/general/splitCenterV.png" : "/general/splitCenterH.png"));
            splitCenterlabel.setCursor(Cursor.getPredefinedCursor(12));
            splitCenterlabel.setToolTipText(UIBundle.message("splitter.center.tooltip.text", new Object[0]));
            splitCenterlabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Splitter.this.setProportion(0.5f);
                }
            });
            this.add((Component)splitCenterlabel, new GridBagConstraints(3 * xMask, 3 * yMask, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(4 * xMask, 4 * yMask, 1, 1, 0.0, 0.0, 10, glueFill, new Insets(0, 0, 0, 0), 0, 0));
            JLabel splitUpLabel = new JLabel(IconLoader.getIcon(isVerticalSplit ? "/general/splitUp.png" : "/general/splitLeft.png"));
            splitUpLabel.setCursor(Cursor.getPredefinedCursor(12));
            splitUpLabel.setToolTipText(isVerticalSplit ? UIBundle.message("splitter.up.tooltip.text", new Object[0]) : UIBundle.message("splitter.left.tooltip.text", new Object[0]));
            splitUpLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Splitter.this.setProportion(Divider.this.getMinProportion(Splitter.this.myFirstComponent));
                }
            });
            this.add((Component)splitUpLabel, new GridBagConstraints(isVerticalSplit ? 5 : 0, isVerticalSplit ? 0 : 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(6 * xMask, 6 * yMask, 1, 1, 0.0, 0.0, isVerticalSplit ? 17 : 15, glueFill, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (506 == e.getID()) {
                this.myDragging = true;
                this.setCursor(Splitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), Splitter.this);
                if (Splitter.this.getOrientation()) {
                    if (this.getHeight() > 0) {
                        float proportion = Math.min(1.0f, Math.max(this.getMinProportion(Splitter.this.myFirstComponent), (float)this.myPoint.y / (float)Splitter.this.getHeight()));
                        Splitter.this.setProportion(proportion);
                    }
                } else if (this.getWidth() > 0) {
                    float proportion = Math.min(1.0f, Math.max(this.getMinProportion(Splitter.this.myFirstComponent), (float)this.myPoint.x / (float)Splitter.this.getWidth()));
                    Splitter.this.setProportion(proportion);
                }
            }
        }

        private float getMinProportion(JComponent component) {
            if (Splitter.this.isHonorMinimumSize() && component != null && Splitter.this.myFirstComponent != null && Splitter.this.myFirstComponent.isVisible() && Splitter.this.mySecondComponent != null && Splitter.this.mySecondComponent.isVisible()) {
                if (Splitter.this.getOrientation()) {
                    return (float)component.getMinimumSize().height / (float)(Splitter.this.getHeight() - Splitter.this.getDividerWidth());
                }
                return (float)component.getMinimumSize().width / (float)(Splitter.this.getWidth() - Splitter.this.getDividerWidth());
            }
            return 0.0f;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            switch (e.getID()) {
                case 504: {
                    this.setCursor(Splitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 505: {
                    if (this.myDragging) break;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 501: {
                    this.setCursor(Splitter.this.getOrientation() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11));
                    break;
                }
                case 502: {
                    this.myDragging = false;
                    this.myPoint = null;
                    break;
                }
                case 500: {
                    if (e.getClickCount() != 2) break;
                    Splitter.this.setProportion(0.5f);
                }
            }
        }
    }
}

