/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DOMWriter {
    private final PrintWriter myOut;
    private final boolean myCanonical;
    @NonNls
    private static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    @NonNls
    private static final String DOCTYPE = "<!DOCTYPE ";
    @NonNls
    private static final String PUBLIC = " PUBLIC '";
    @NonNls
    private static final String SYSTEM = " SYSTEM '";
    @NonNls
    private static final String QUOT = "&quot;";
    @NonNls
    private static final String AMP = "&amp;";
    @NonNls
    private static final String GT = "&gt;";
    @NonNls
    private static final String LT = "&lt;";
    @NonNls
    private static final String CDATA = "<![CDATA[";
    private static final int INDENT = 2;

    public DOMWriter(boolean canonical, PrintWriter printWriter) {
        this.myCanonical = canonical;
        this.myOut = printWriter;
    }

    public void write(Node node) {
        this._write(node, 0);
        this.myOut.println();
    }

    private void _write(Node node, int indent) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Document document = (Document)node;
                this.myOut.println(XML_PROLOG);
                this._write(document.getDoctype(), indent);
                this._write(document.getDocumentElement(), indent);
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.myOut.print(DOCTYPE);
                this.myOut.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.myOut.print(PUBLIC);
                    this.myOut.print(publicId);
                    this.myOut.print("' '");
                    this.myOut.print(systemId);
                    this.myOut.print('\'');
                } else {
                    this.myOut.print(SYSTEM);
                    this.myOut.print(systemId);
                    this.myOut.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.myOut.println(" [");
                    this.myOut.print(internalSubset);
                    this.myOut.print(']');
                }
                this.myOut.println('>');
                break;
            }
            case 1: {
                this.indent(indent);
                this.myOut.print('<');
                this.myOut.print(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    this.myOut.print(' ');
                    this.myOut.print(attr.getNodeName());
                    this.myOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue());
                    this.myOut.print('\"');
                }
                Node child = node.getFirstChild();
                if (child == null) {
                    this.myOut.println(" />");
                } else {
                    this.myOut.print('>');
                    boolean firstChild = true;
                    boolean indentNeeded = false;
                    while (child != null) {
                        if (child instanceof Element) {
                            if (firstChild) {
                                this.myOut.println();
                                indentNeeded = true;
                            }
                            firstChild = false;
                        } else if (child.getNodeValue().trim().length() > 0) {
                            firstChild = false;
                        }
                        this._write(child, indent + 2);
                        child = child.getNextSibling();
                    }
                    if (indentNeeded) {
                        this.indent(indent);
                    }
                    this.myOut.print("</");
                    this.myOut.print(node.getNodeName());
                    this.myOut.println('>');
                    break;
                }
            }
            case 5: {
                if (this.myCanonical) {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this._write(child, indent);
                    }
                    break;
                }
                this.myOut.print('&');
                this.myOut.print(node.getNodeName());
                this.myOut.print(';');
                break;
            }
            case 4: {
                if (this.myCanonical) {
                    this.normalizeAndPrint(node.getNodeValue());
                    break;
                }
                this.myOut.print(CDATA);
                this.myOut.print(node.getNodeValue());
                this.myOut.print("]]>");
                break;
            }
            case 3: {
                String nodeValue = node.getNodeValue();
                if (nodeValue.trim().length() <= 0) break;
                this.normalizeAndPrint(nodeValue.trim());
                break;
            }
            case 7: {
                this.myOut.print("<?");
                this.myOut.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.myOut.print(' ');
                    this.myOut.print(data);
                }
                this.myOut.println("?>");
                break;
            }
        }
    }

    private void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.myOut.print(' ');
        }
    }

    @Nullable
    private static Attr[] sortAttributes(NamedNodeMap attrs) {
        if (attrs == null) {
            return null;
        }
        int len = attrs.getLength();
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        return array;
    }

    private void normalizeAndPrint(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c);
        }
    }

    private void normalizeAndPrint(char c) {
        switch (c) {
            case '<': {
                this.myOut.print(LT);
                break;
            }
            case '>': {
                this.myOut.print(GT);
                break;
            }
            case '&': {
                this.myOut.print(AMP);
                break;
            }
            case '\"': {
                this.myOut.print(QUOT);
                break;
            }
            case '\n': 
            case '\r': {
                if (this.myCanonical) {
                    this.myOut.print("&#");
                    this.myOut.print(Integer.toString(c));
                    this.myOut.print(';');
                    break;
                }
            }
            default: {
                this.myOut.print(c);
            }
        }
    }
}

