/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.WeakReferenceArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class WeakList<T>
extends AbstractList<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.containers.WeakList");
    private final WeakReferenceArray<T> myArray;
    private int myCompressCountdown = 10;

    public WeakList() {
        this(new WeakReferenceArray());
    }

    WeakList(WeakReferenceArray<T> array) {
        this.myArray = array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            return this.myArray.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element) {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            this.tryReduceCapacity(-1);
            this.myArray.add(element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            this.tryReduceCapacity(-1);
            this.myArray.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            this.tryReduceCapacity(-1);
            return this.myArray.remove(index);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            return this.myArray.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> toStrongList() {
        WeakReferenceArray<T> weakReferenceArray = this.myArray;
        synchronized (weakReferenceArray) {
            ArrayList result = new ArrayList();
            this.myArray.toStrongCollection(result);
            return result;
        }
    }

    private int tryReduceCapacity(int trackIndex) {
        ++this.modCount;
        if (this.canReduceCapacity()) {
            return this.myArray.reduceCapacity(trackIndex);
        }
        return this.propablyCompress(trackIndex);
    }

    private int propablyCompress(int trackIndex) {
        --this.myCompressCountdown;
        if (this.myCompressCountdown > 0) {
            return trackIndex;
        }
        int newIndex = this.myArray.compress(trackIndex);
        this.myCompressCountdown = this.myArray.size() + 10;
        return newIndex;
    }

    private boolean canReduceCapacity() {
        return 10 < this.myArray.getCapacity() && this.myArray.getCapacity() > this.myArray.getAliveCount() * 3;
    }

    static /* synthetic */ int access$000(WeakList x0) {
        return x0.modCount;
    }

    private class MyIterator
    implements Iterator<T> {
        private int myNextIndex = -1;
        private int myCurrentIndex = -1;
        private T myNextElement = null;
        private int myModCount = WeakList.access$000(WeakList.this);

        public MyIterator() {
            this.findNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findNext() {
            WeakReferenceArray weakReferenceArray = WeakList.this.myArray;
            synchronized (weakReferenceArray) {
                this.myNextElement = null;
                while (this.myNextElement == null) {
                    this.myNextIndex = WeakList.this.myArray.nextValid(this.myNextIndex);
                    if (this.myNextIndex >= WeakList.this.myArray.size()) {
                        this.myNextIndex = -1;
                        this.myNextElement = null;
                        return;
                    }
                    this.myNextElement = WeakList.this.myArray.get(this.myNextIndex);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.myNextElement != null;
        }

        @Override
        public T next() {
            if (WeakList.this.modCount != this.myModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.myNextElement == null) {
                throw new NoSuchElementException();
            }
            Object element = this.myNextElement;
            this.myCurrentIndex = this.myNextIndex;
            this.findNext();
            return element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            WeakReferenceArray weakReferenceArray = WeakList.this.myArray;
            synchronized (weakReferenceArray) {
                if (this.myCurrentIndex == -1) {
                    throw new IllegalStateException();
                }
                WeakList.this.myArray.remove(this.myCurrentIndex);
                int removedIndex = this.myCurrentIndex;
                int newIndex = WeakList.this.tryReduceCapacity(this.myNextIndex);
                this.myCurrentIndex = -1;
                this.myModCount = WeakList.this.modCount;
                if (!this.hasNext()) {
                    return;
                }
                if (newIndex < 0) {
                    LOG.error(" was: " + this.myNextIndex + " got: " + newIndex + " size: " + WeakList.this.myArray.size() + " current: " + removedIndex);
                }
                this.myNextIndex = newIndex;
                LOG.assertTrue(WeakList.this.myArray.get(this.myNextIndex) == this.myNextElement);
            }
        }
    }
}

