/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.io.Bits;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class PersistentEnumerator<Data>
implements Forceable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.PersistentEnumerator");
    protected static final int NULL_ID = 0;
    protected static final int DATA_OFFSET = 8;
    private static final int META_DATA_OFFSET = 4;
    private static final int FIRST_VECTOR_OFFSET = 8;
    private static final int DIRTY_MAGIC = -1161951863;
    private static final int VERSION = 5;
    private static final int CORRECTLY_CLOSED_MAGIC = -341069903;
    private static final int BITS_PER_LEVEL = 4;
    private static final int SLOTS_PER_VECTOR = 16;
    private static final int LEVEL_MASK = 15;
    private static final byte[] EMPTY_VECTOR = new byte[64];
    private static final int BITS_PER_FIRST_LEVEL = 12;
    private static final int SLOTS_PER_FIRST_VECTOR = 4096;
    private static final int FIRST_LEVEL_MASK = 4095;
    private static final byte[] FIRST_VECTOR = new byte[16384];
    protected final ResizeableMappedFile myStorage;
    private final ResizeableMappedFile myKeyStorage;
    private boolean myClosed = false;
    private boolean myDirty = false;
    private final KeyDescriptor<Data> myDataDescriptor;
    private final byte[] myBuffer = new byte[12];
    private static final CacheKey ourFlyweight = new FlyweightKey();
    private final File myFile;
    private static final int COLLISION_OFFSET = 0;
    private static final int KEY_HASHCODE_OFFSET = 4;
    private static final int KEY_REF_OFFSET = 8;
    protected static final int RECORD_SIZE = 12;
    private boolean myCorrupted = false;
    private final MyDataIS myKeyReadStream;
    protected static final PagedFileStorage.StorageLock ourLock = new PagedFileStorage.StorageLock();
    private static final SLRUMap<Object, Integer> ourEnumerationCache = new SLRUMap(8192, 8192);

    private static CacheKey sharedKey(Object key, PersistentEnumerator owner) {
        PersistentEnumerator.ourFlyweight.key = key;
        PersistentEnumerator.ourFlyweight.owner = owner;
        return ourFlyweight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumerator(File file, KeyDescriptor<Data> dataDescriptor, int initialSize) throws IOException {
        this.myDataDescriptor = dataDescriptor;
        this.myFile = file;
        if (!file.exists()) {
            FileUtil.delete(this.keystreamFile());
            if (!FileUtil.createIfDoesntExist(file)) {
                throw new IOException("Cannot create empty file: " + file);
            }
        }
        this.myStorage = new ResizeableMappedFile(this.myFile, initialSize, ourLock);
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (this.myStorage.length() == 0L) {
                this.markDirty(true);
                this.putMetaData(0);
                this.allocVector(FIRST_VECTOR);
            } else {
                int sign;
                try {
                    sign = this.myStorage.getInt(0);
                }
                catch (Exception e) {
                    LOG.info(e);
                    sign = -1161951863;
                }
                if (sign != -341069903) {
                    this.myStorage.close();
                    throw new CorruptedException(file);
                }
            }
        }
        if (this.myDataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = null;
            this.myKeyReadStream = null;
        } else {
            this.myKeyStorage = new ResizeableMappedFile(this.keystreamFile(), initialSize, ourLock);
            this.myKeyReadStream = new MyDataIS(this.myKeyStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int tryEnumerate(Data value) throws IOException {
        int id;
        SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
        synchronized (sLRUMap) {
            Integer cachedId = ourEnumerationCache.get(PersistentEnumerator.sharedKey(value, this));
            if (cachedId != null) {
                return cachedId;
            }
        }
        Object object = ourLock;
        synchronized (object) {
            id = this.enumerateImpl(value, false);
        }
        if (id != 0) {
            object = ourEnumerationCache;
            synchronized (object) {
                ourEnumerationCache.put(new CacheKey(value, this), id);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int enumerate(Data value) throws IOException {
        int id;
        SLRUMap<Object, Integer> sLRUMap = ourEnumerationCache;
        synchronized (sLRUMap) {
            Integer cachedId = ourEnumerationCache.get(PersistentEnumerator.sharedKey(value, this));
            if (cachedId != null) {
                return cachedId;
            }
        }
        Object object = ourLock;
        synchronized (object) {
            id = this.enumerateImpl(value, true);
        }
        object = ourEnumerationCache;
        synchronized (object) {
            ourEnumerationCache.put(new CacheKey(value, this), id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void putMetaData(int data) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            this.myStorage.putInt(4, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized int getMetaData() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            return this.myStorage.getInt(4);
        }
    }

    public boolean processAllDataObject(final Processor<Data> processor, final @Nullable DataFilter filter) throws IOException {
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter == null || filter.accept(record)) {
                    return processor.process(PersistentEnumerator.this.valueOf(record));
                }
                return true;
            }
        });
    }

    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter) throws IOException {
        ArrayList values = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values), filter);
        return values;
    }

    public synchronized boolean traverseAllRecords(RecordsProcessor p) throws IOException {
        return this.traverseRecords(8, 4096, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverseRecords(int vectorStart, int slotsCount, RecordsProcessor p) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            for (int slotIdx = 0; slotIdx < slotsCount; ++slotIdx) {
                int vector = this.myStorage.getInt(vectorStart + slotIdx * 4);
                if (vector < 0) {
                    int record = -vector;
                    while (record != 0) {
                        if (!p.process(record)) {
                            return false;
                        }
                        record = this.nextCanditate(record);
                    }
                    continue;
                }
                if (vector <= 0 || this.traverseRecords(vector, 16, p)) continue;
                return false;
            }
            return true;
        }
    }

    private int enumerateImpl(Data value, boolean saveNewValue) throws IOException {
        try {
            int newId;
            block12: {
                int candidateHC;
                int pos;
                int lastVector;
                int valueHC;
                int depth = 0;
                int hc = valueHC = this.myDataDescriptor.getHashCode(value);
                int vector = 8;
                int levelMask = 4095;
                int bitsPerLevel = 12;
                do {
                    lastVector = vector;
                    pos = vector + (hc & levelMask) * 4;
                    hc >>>= bitsPerLevel;
                    vector = this.myStorage.getInt(pos);
                    ++depth;
                    levelMask = 15;
                    bitsPerLevel = 4;
                } while (vector > 0);
                if (vector == 0) {
                    if (!saveNewValue) {
                        return 0;
                    }
                    int newId2 = this.writeData(value, valueHC);
                    this.myStorage.putInt(pos, -newId2);
                    return newId2;
                }
                int collision = -vector;
                boolean splitVector = false;
                do {
                    if ((candidateHC = this.hashCodeOf(collision)) != valueHC) {
                        splitVector = true;
                        break;
                    }
                    Data candidate = this.valueOf(collision);
                    if (!this.myDataDescriptor.isEqual(value, candidate)) continue;
                    return collision;
                } while ((collision = this.nextCanditate(collision)) != 0);
                if (!saveNewValue) {
                    return 0;
                }
                newId = this.writeData(value, valueHC);
                if (splitVector) {
                    --depth;
                    while (true) {
                        int oldHCByte;
                        int valueHCByte;
                        if ((valueHCByte = PersistentEnumerator.hcByte(valueHC, depth)) != (oldHCByte = PersistentEnumerator.hcByte(candidateHC, depth))) {
                            this.myStorage.putInt(lastVector + valueHCByte * 4, -newId);
                            this.myStorage.putInt(lastVector + oldHCByte * 4, vector);
                            break block12;
                        }
                        int newVector = this.allocVector(EMPTY_VECTOR);
                        this.myStorage.putInt(lastVector + oldHCByte * 4, newVector);
                        lastVector = newVector;
                        ++depth;
                    }
                }
                this.myStorage.putInt(newId, vector);
                this.myStorage.putInt(pos, -newId);
            }
            return newId;
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
        catch (Throwable e) {
            this.markCorrupted();
            throw new RuntimeException(e);
        }
    }

    private static int hcByte(int hashcode, int byteN) {
        if (byteN == 0) {
            return hashcode & 0xFFF;
        }
        return (hashcode >>>= 12) >>> --byteN * 4 & 0xF;
    }

    private int allocVector(byte[] empty) throws IOException {
        int pos = (int)this.myStorage.length();
        this.myStorage.put(pos, empty, 0, empty.length);
        return pos;
    }

    private int nextCanditate(int idx) throws IOException {
        return -this.myStorage.getInt(idx);
    }

    private int writeData(Data value, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.myKeyStorage != null ? (int)this.myKeyStorage.length() : ((InlineKeyDescriptor)this.myDataDescriptor).toInt(value);
            byte[] buf = this.prepareEntryRecordBuf(hashCode, dataOff);
            if (this.myKeyStorage != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bos);
                this.myDataDescriptor.save(out, value);
                this.myKeyStorage.put(dataOff, bos.toByteArray(), 0, bos.size());
            }
            ResizeableMappedFile storage = this.myStorage;
            int pos = (int)storage.length();
            storage.put(pos, buf, 0, buf.length);
            return pos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] prepareEntryRecordBuf(int hashCode, int dataOffset) {
        byte[] buf = this.getRecordBuffer();
        this.setupRecord(hashCode, dataOffset, buf);
        return buf;
    }

    protected byte[] getRecordBuffer() {
        return this.myBuffer;
    }

    protected void setupRecord(int hashCode, int dataOffset, byte[] buf) {
        Bits.putInt(buf, 0, 0);
        Bits.putInt(buf, 4, hashCode);
        Bits.putInt(buf, 8, dataOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean iterateData(Processor<Data> processor) throws IOException {
        if (this.myKeyStorage == null) {
            throw new UnsupportedOperationException("Iteration over InlineIntegerKeyDescriptors is not supported");
        }
        this.myKeyStorage.force();
        DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(this.keystreamFile()), (int)this.myKeyStorage.length())));
        try {
            while (true) {
                Object key;
                if (!processor.process(key = this.myDataDescriptor.read(keysStream))) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = true;
            return bl;
        }
        finally {
            keysStream.close();
        }
    }

    private File keystreamFile() {
        return new File(this.myFile.getPath() + ".keystream");
    }

    private int hashCodeOf(int idx) throws IOException {
        return this.myStorage.getInt(idx + 4);
    }

    public synchronized Data valueOf(int idx) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            try {
                ResizeableMappedFile storage = this.myStorage;
                int addr = storage.getInt(idx + 8);
                if (this.myKeyReadStream == null) {
                    return (Data)((InlineKeyDescriptor)this.myDataDescriptor).fromInt(addr);
                }
                this.myKeyReadStream.setup(addr, this.myKeyStorage.length());
                return (Data)this.myDataDescriptor.read(this.myKeyReadStream);
            }
            catch (IOException io) {
                this.markCorrupted();
                throw io;
            }
            catch (Throwable e) {
                this.markCorrupted();
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (!this.myClosed) {
                this.myClosed = true;
                try {
                    if (this.myKeyStorage != null) {
                        this.myKeyStorage.close();
                    }
                    this.flush();
                }
                finally {
                    this.myStorage.close();
                }
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public synchronized boolean isDirty() {
        return this.myDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush() throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (this.myStorage.isDirty() || this.isDirty()) {
                this.markDirty(false);
                this.myStorage.force();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void force() {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            try {
                if (this.myKeyStorage != null) {
                    this.myKeyStorage.force();
                }
                this.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markDirty(boolean dirty) throws IOException {
        PagedFileStorage.StorageLock storageLock = ourLock;
        synchronized (storageLock) {
            if (this.myDirty) {
                if (!dirty) {
                    this.markClean();
                }
            } else if (dirty) {
                this.myStorage.putInt(0, -1161951863);
                this.myDirty = true;
            }
        }
    }

    private void markCorrupted() {
        if (!this.myCorrupted) {
            this.myCorrupted = true;
            try {
                this.markDirty(true);
                this.force();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void markClean() throws IOException {
        if (!this.myCorrupted) {
            this.myStorage.putInt(0, -341069903);
            this.myDirty = false;
        }
    }

    private static class FlyweightKey
    extends CacheKey {
        public FlyweightKey() {
            super(null, null);
        }

        @Override
        public ShareableKey getStableCopy() {
            return new CacheKey(this.key, this.owner);
        }
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        public MyBufferedIS(InputStream in) {
            super(in, 512);
        }

        public void setup(long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            ((MappedFileInputStream)this.in).setup(pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS(ResizeableMappedFile raf) {
            super(new MyBufferedIS(new MappedFileInputStream(raf, 0L, 0L)));
        }

        public void setup(long pos, long limit) {
            ((MyBufferedIS)this.in).setup(pos, limit);
        }
    }

    public static interface RecordsProcessor {
        public boolean process(int var1) throws IOException;
    }

    public static interface DataFilter {
        public boolean accept(int var1);
    }

    public static class CorruptedException
    extends IOException {
        public CorruptedException(File file) {
            super("PersistentStringEnumerator storage corrupted " + file.getPath());
        }
    }

    private static class CacheKey
    implements ShareableKey {
        public PersistentEnumerator owner;
        public Object key;

        private CacheKey(Object key, PersistentEnumerator owner) {
            this.key = key;
            this.owner = owner;
        }

        @Override
        public ShareableKey getStableCopy() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.key.equals(cacheKey.key)) {
                return false;
            }
            return this.owner.equals(cacheKey.owner);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

