/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.utils.ElementChecker;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ElementCheckerImpl
implements ElementChecker {
    @Override
    public boolean isNamespaceElement(Node node, String string, String string2) {
        return node != null && string2 == node.getNamespaceURI() && node.getLocalName().equals(string);
    }

    public static class EmptyChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
        }
    }

    public static class FullChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
            String string = elementProxy.getBaseLocalName();
            String string2 = elementProxy.getBaseNamespace();
            String string3 = element.getLocalName();
            String string4 = element.getNamespaceURI();
            if (!string2.equals(string4) || !string.equals(string3)) {
                Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }

    public static class InternedNsChecker
    extends ElementCheckerImpl {
        @Override
        public void guaranteeThatElementInCorrectSpace(ElementProxy elementProxy, Element element) throws XMLSecurityException {
            String string = elementProxy.getBaseLocalName();
            String string2 = elementProxy.getBaseNamespace();
            String string3 = element.getLocalName();
            String string4 = element.getNamespaceURI();
            if (string2 != string4 || !string.equals(string3)) {
                Object[] objectArray = new Object[]{string4 + ":" + string3, string2 + ":" + string};
                throw new XMLSecurityException("xml.WrongElement", objectArray);
            }
        }
    }
}

