/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.NoAccessException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import sun.dyn.Access;
import sun.dyn.Invokers;
import sun.dyn.MemberName;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodTypeImpl;
import sun.dyn.empty.Empty;
import sun.dyn.util.VerifyAccess;
import sun.dyn.util.Wrapper;
import sun.reflect.Reflection;

public class MethodHandles {
    private static final Access IMPL_TOKEN = Access.getToken();
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory(IMPL_TOKEN);

    private MethodHandles() {
    }

    public static Lookup lookup() {
        return new Lookup();
    }

    static MethodHandle findStaticFrom(Class<?> clazz, Class<?> clazz2, String string, MethodType methodType) throws NoAccessException {
        MemberName memberName = IMPL_NAMES.resolveOrFail(new MemberName(clazz2, string, methodType, 8), true, clazz);
        MethodHandles.checkStatic(true, memberName, clazz);
        return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, clazz);
    }

    static void checkStatic(boolean bl, MemberName memberName, Class<?> clazz) {
        if (bl != memberName.isStatic()) {
            String string = bl ? "expected a static method" : "expected a non-static method";
            throw MemberName.newNoAccessException(string, memberName, clazz);
        }
    }

    static void checkSpecialCaller(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == Lookup.IMPL_LOOKUP.lookupClass()) {
            return;
        }
        if (clazz2 == null || !VerifyAccess.isSamePackageMember(clazz, clazz2)) {
            throw MemberName.newNoAccessException("no private access", new MemberName(clazz), clazz2);
        }
    }

    static MethodHandle unreflectImpl(MemberName memberName, boolean bl, boolean bl2, Class<?> clazz) {
        MethodType methodType = memberName.getInvocationType();
        Class<?> clazz2 = memberName.getDeclaringClass();
        int n = memberName.getModifiers();
        if (memberName.isStatic()) {
            if (!bl && VerifyAccess.isAccessible(clazz2, n, false, clazz) == null) {
                throw MemberName.newNoAccessException(memberName, clazz);
            }
        } else {
            Class<?> clazz3 = bl ? (bl2 ? clazz2 : clazz) : VerifyAccess.isAccessible(clazz2, n, bl2, clazz);
            if (clazz3 != clazz2 && !clazz3.isAssignableFrom(clazz2)) {
                if (!clazz2.isAssignableFrom(clazz3)) {
                    throw MemberName.newNoAccessException("receiver must be in caller class", memberName, clazz);
                }
                methodType = methodType.changeParameterType(0, clazz3);
            }
        }
        return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, bl2, clazz);
    }

    public static MethodHandle arrayElementGetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(IMPL_TOKEN, clazz, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> clazz) throws IllegalArgumentException {
        return MethodHandleImpl.accessArrayElement(IMPL_TOKEN, clazz, true);
    }

    public static Object invoke(MethodHandle methodHandle, Object ... objectArray) {
        MethodHandle methodHandle2;
        int n = objectArray == null ? 0 : objectArray.length;
        MethodType methodType = methodHandle.type();
        if (n <= 4) {
            methodHandle2 = MethodHandles.invokers(methodType).genericInvoker();
            switch (n) {
                case 0: {
                    return methodHandle2.invoke(methodHandle);
                }
                case 1: {
                    return methodHandle2.invoke(methodHandle, objectArray[0]);
                }
                case 2: {
                    return methodHandle2.invoke(methodHandle, objectArray[0], objectArray[1]);
                }
                case 3: {
                    return methodHandle2.invoke(methodHandle, objectArray[0], objectArray[1], objectArray[2]);
                }
                case 4: {
                    return methodHandle2.invoke(methodHandle, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
                }
            }
        }
        methodHandle2 = MethodHandles.invokers(methodType).varargsInvoker();
        return methodHandle2.invoke(methodHandle, objectArray);
    }

    public static Object invoke_0(MethodHandle methodHandle) {
        MethodHandle methodHandle2 = MethodHandles.invokers(methodHandle.type()).genericInvoker();
        return methodHandle2.invoke(methodHandle);
    }

    public static Object invoke_1(MethodHandle methodHandle, Object object) {
        MethodHandle methodHandle2 = MethodHandles.invokers(methodHandle.type()).genericInvoker();
        return methodHandle2.invoke(methodHandle, object);
    }

    public static Object invoke_2(MethodHandle methodHandle, Object object, Object object2) {
        MethodHandle methodHandle2 = MethodHandles.invokers(methodHandle.type()).genericInvoker();
        return methodHandle2.invoke(methodHandle, object, object2);
    }

    public static Object invoke_3(MethodHandle methodHandle, Object object, Object object2, Object object3) {
        MethodHandle methodHandle2 = MethodHandles.invokers(methodHandle.type()).genericInvoker();
        return methodHandle2.invoke(methodHandle, object, object2, object3);
    }

    public static Object invoke_4(MethodHandle methodHandle, Object object, Object object2, Object object3, Object object4) {
        MethodHandle methodHandle2 = MethodHandles.invokers(methodHandle.type()).genericInvoker();
        return methodHandle2.invoke(methodHandle, object, object2, object3, object4);
    }

    public static MethodHandle genericInvoker(MethodType methodType, int n, boolean bl) {
        return MethodHandles.invokers(methodType).genericInvoker();
    }

    public static MethodHandle exactInvoker(MethodType methodType) {
        return MethodHandles.invokers(methodType).exactInvoker();
    }

    private static Invokers invokers(MethodType methodType) {
        return MethodTypeImpl.invokers(IMPL_TOKEN, methodType);
    }

    static <T0, T1> T1 checkValue(Class<T0> clazz, Class<T1> clazz2, Object object) throws ClassCastException {
        if (clazz == clazz2) {
            if (clazz.isPrimitive()) {
                return Wrapper.asPrimitiveType(clazz2).cast(object);
            }
            return Wrapper.OBJECT.cast(object, clazz2);
        }
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (!bl) {
            Wrapper.OBJECT.cast(object, clazz);
            if (!bl2) {
                return Wrapper.OBJECT.cast(object, clazz2);
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            return wrapper.cast(object, clazz2);
        }
        Wrapper.asWrapperType(clazz).cast(object);
        Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
        return wrapper.cast(object, clazz2);
    }

    static Object checkValue(Class<?> clazz, Object object) throws ClassCastException {
        Class clazz2 = object == null ? Object.class : object.getClass();
        return MethodHandles.checkValue(clazz2, clazz, object);
    }

    public static MethodHandle convertArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        if (methodType2.equals((Object)methodType)) {
            return methodHandle;
        }
        MethodHandle methodHandle2 = MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle, methodType, methodType2, null);
        if (methodHandle2 == null) {
            throw MemberName.newIllegalArgumentException("cannot convert to " + methodType + ": " + methodHandle);
        }
        return methodHandle2;
    }

    public static MethodHandle permuteArguments(MethodHandle methodHandle, MethodType methodType, int[] nArray) {
        MethodType methodType2 = methodHandle.type();
        MethodHandles.checkReorder(nArray, methodType, methodType2);
        return MethodHandleImpl.convertArguments(IMPL_TOKEN, methodHandle, methodType, methodType2, nArray);
    }

    private static void checkReorder(int[] nArray, MethodType methodType, MethodType methodType2) {
        if (nArray.length == methodType2.parameterCount()) {
            int n = methodType.parameterCount();
            boolean bl = false;
            for (int n2 : nArray) {
                if (n2 >= 0 && n2 < n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        throw MemberName.newIllegalArgumentException("bad reorder array");
    }

    public static MethodHandle spreadArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n - 1;
        int n4 = n2 - n3;
        MethodHandle methodHandle2 = null;
        if (n3 >= 0 && n4 >= 0) {
            methodHandle2 = MethodHandleImpl.spreadArguments(IMPL_TOKEN, methodHandle, methodType, n3);
        }
        if (methodHandle2 == null) {
            throw MemberName.newIllegalArgumentException("cannot spread " + methodType + " to " + methodType2);
        }
        return methodHandle2;
    }

    public static MethodHandle collectArguments(MethodHandle methodHandle, MethodType methodType) {
        MethodType methodType2 = methodHandle.type();
        int n = methodType.parameterCount();
        int n2 = methodType2.parameterCount();
        int n3 = n2 - 1;
        int n4 = n - n3;
        if (n3 < 0 || n4 < 0) {
            throw MemberName.newIllegalArgumentException("wrong number of arguments");
        }
        return MethodHandleImpl.collectArguments(IMPL_TOKEN, methodHandle, methodType, n3);
    }

    public static MethodHandle insertArgument(MethodHandle methodHandle, int n, Object object) {
        MethodHandle methodHandle2;
        MethodType methodType = methodHandle.type();
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        int n2 = methodType.parameterCount();
        int n3 = n2 - 1;
        if (n < 0 || n >= n2) {
            throw MemberName.newIllegalArgumentException("no argument type to append");
        }
        Class<?> clazz = arrayList.remove(n);
        object = MethodHandles.checkValue(clazz, object);
        if (n == 0 && !clazz.isPrimitive() && (methodHandle2 = MethodHandleImpl.bindReceiver(IMPL_TOKEN, methodHandle, object)) != null) {
            return methodHandle2;
        }
        return MethodHandleImpl.bindArgument(IMPL_TOKEN, methodHandle, n, object);
    }

    public static MethodHandle dropArguments(MethodHandle methodHandle, int n, Class<?> ... classArray) {
        if (classArray.length == 0) {
            return methodHandle;
        }
        MethodType methodType = methodHandle.type();
        int n2 = methodType.parameterCount();
        int n3 = n2 + classArray.length;
        if (n < 0 || n >= n3) {
            throw MemberName.newIllegalArgumentException("no argument type to remove");
        }
        ArrayList arrayList = new ArrayList(methodType.parameterList());
        arrayList.addAll(n, Arrays.asList(classArray));
        MethodType methodType2 = MethodType.make(methodType.returnType(), arrayList);
        return MethodHandleImpl.dropArguments(IMPL_TOKEN, methodHandle, methodType2, n);
    }

    public static MethodHandle guardWithTest(MethodHandle methodHandle, MethodHandle methodHandle2, MethodHandle methodHandle3) {
        if (methodHandle2.type() != methodHandle3.type()) {
            throw MemberName.newIllegalArgumentException("target and fallback types do not match");
        }
        if (methodHandle2.type().changeReturnType(Boolean.TYPE) != methodHandle.type()) {
            throw MemberName.newIllegalArgumentException("target and test types do not match");
        }
        return MethodHandleImpl.makeGuardWithTest(IMPL_TOKEN, methodHandle, methodHandle2, methodHandle3);
    }

    public static MethodHandle combineArguments(MethodHandle methodHandle, int n, MethodHandle methodHandle2) {
        MethodType methodType;
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz = methodHandle2.type().returnType();
        if (n < 0) {
            methodType = methodType2;
            if (!methodType.changeReturnType(clazz).equals((Object)methodHandle2.type())) {
                throw MemberName.newIllegalArgumentException("target and combiner types do not match");
            }
        } else {
            if (n >= methodType2.parameterCount() || methodType2.parameterType(n) != clazz) {
                throw MemberName.newIllegalArgumentException("inserted combiner argument does not match target");
            }
            methodType = methodType2.dropParameterType(n);
        }
        if (!methodType.changeReturnType(clazz).equals((Object)methodHandle2.type())) {
            throw MemberName.newIllegalArgumentException("target and combiner types do not match");
        }
        return MethodHandleImpl.combineArguments(IMPL_TOKEN, methodHandle, methodHandle2, n);
    }

    static {
        MethodHandleImpl.initStatics();
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private static final Class<?> PUBLIC_ONLY = Empty.class;
        public static final Lookup PUBLIC_LOOKUP = new Lookup(PUBLIC_ONLY);
        static final Lookup IMPL_LOOKUP = new Lookup(null);

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        Lookup() {
            Class<?> clazz = Lookup.getCallerClassAtEntryPoint();
            Lookup.checkUnprivilegedlookupClass(clazz);
            this.lookupClass = clazz;
        }

        private Lookup(Class<?> clazz) {
            this.lookupClass = clazz;
        }

        private static void checkUnprivilegedlookupClass(Class<?> clazz) {
            String string = clazz.getName();
            if (string.startsWith("java.dyn.") || string.startsWith("sun.dyn.")) {
                throw MemberName.newIllegalArgumentException("illegal lookupClass: " + clazz);
            }
        }

        public String toString() {
            if (this.lookupClass == PUBLIC_ONLY) {
                return "public";
            }
            if (this.lookupClass == null) {
                return "privileged";
            }
            return this.lookupClass.getName();
        }

        private static Class<?> getCallerClassAtEntryPoint() {
            return Reflection.getCallerClass(4);
        }

        public MethodHandle findStatic(Class<?> clazz, String string, MethodType methodType) throws NoAccessException {
            MemberName memberName = IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType, 8), true, this.lookupClass);
            MethodHandles.checkStatic(true, memberName, this.lookupClass);
            return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, this.lookupClass);
        }

        public MethodHandle findVirtual(Class<?> clazz, String string, MethodType methodType) throws NoAccessException {
            MemberName memberName = IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType), true, this.lookupClass);
            MethodHandles.checkStatic(false, memberName, this.lookupClass);
            return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, true, this.lookupClass);
        }

        public MethodHandle findSpecial(Class<?> clazz, String string, MethodType methodType, Class<?> clazz2) throws NoAccessException {
            MethodHandles.checkSpecialCaller(clazz2, this.lookupClass);
            MemberName memberName = IMPL_NAMES.resolveOrFail(new MemberName(clazz, string, methodType), false, clazz2);
            MethodHandles.checkStatic(false, memberName, this.lookupClass);
            if (string.equals("<init>")) {
                throw MemberName.newNoAccessException("cannot directly invoke a constructor", memberName, null);
            }
            if (clazz.isInterface() || !clazz.isAssignableFrom(clazz2)) {
                throw MemberName.newNoAccessException("method must be in a superclass of lookup class", memberName, this.lookupClass);
            }
            return MethodHandleImpl.findMethod(IMPL_TOKEN, memberName, false, clazz2);
        }

        public MethodHandle bind(Object object, String string, MethodType methodType) throws NoAccessException {
            Class<?> clazz = object.getClass();
            MemberName memberName = new MemberName(clazz, string, methodType);
            MemberName memberName2 = IMPL_NAMES.resolveOrFail(memberName, true, this.lookupClass);
            MethodHandles.checkStatic(false, memberName2, this.lookupClass);
            MethodHandle methodHandle = MethodHandleImpl.findMethod(IMPL_TOKEN, memberName2, true, this.lookupClass);
            MethodHandle methodHandle2 = MethodHandleImpl.bindReceiver(IMPL_TOKEN, methodHandle, object);
            if (methodHandle2 == null) {
                throw MemberName.newNoAccessException(memberName2, this.lookupClass);
            }
            return methodHandle2;
        }

        public MethodHandle unreflect(Method method) throws NoAccessException {
            return MethodHandles.unreflectImpl(new MemberName(method), method.isAccessible(), true, this.lookupClass);
        }

        public MethodHandle unreflectSpecial(Method method, Class<?> clazz) throws NoAccessException {
            MethodHandles.checkSpecialCaller(clazz, this.lookupClass);
            MemberName memberName = new MemberName(method);
            MethodHandles.checkStatic(false, memberName, this.lookupClass);
            return MethodHandles.unreflectImpl(memberName, method.isAccessible(), false, clazz);
        }

        public MethodHandle unreflectConstructor(Constructor constructor) throws NoAccessException {
            MemberName memberName = new MemberName(constructor);
            return MethodHandles.unreflectImpl(memberName, constructor.isAccessible(), false, this.lookupClass);
        }

        public MethodHandle unreflectGetter(Field field) throws NoAccessException {
            return MethodHandleImpl.accessField(IMPL_TOKEN, new MemberName(field), false, this.lookupClass);
        }

        public MethodHandle unreflectSetter(Field field) throws NoAccessException {
            return MethodHandleImpl.accessField(IMPL_TOKEN, new MemberName(field), true, this.lookupClass);
        }

        static {
            MethodHandleImpl.initLookup(IMPL_TOKEN, IMPL_LOOKUP);
        }
    }
}

