/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AndQueryExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.QueryExp;

class OrQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = 2962973084421716523L;
    private QueryExp exp1;
    private QueryExp exp2;

    public OrQueryExp() {
    }

    public OrQueryExp(QueryExp queryExp, QueryExp queryExp2) {
        this.exp1 = queryExp;
        this.exp2 = queryExp2;
    }

    public QueryExp getLeftExp() {
        return this.exp1;
    }

    public QueryExp getRightExp() {
        return this.exp2;
    }

    @Override
    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        return this.exp1.apply(objectName) || this.exp2.apply(objectName);
    }

    public String toString() {
        return "(" + this.exp1 + ") or (" + this.exp2 + ")";
    }

    @Override
    String toQueryString() {
        return OrQueryExp.parens(this.exp1) + " or " + OrQueryExp.parens(this.exp2);
    }

    private static String parens(QueryExp queryExp) {
        String string = Query.toString(queryExp);
        if (queryExp instanceof AndQueryExp) {
            return "(" + string + ")";
        }
        return string;
    }
}

