/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.event.LeaseManager;
import com.sun.jmx.interceptor.SingleMBeanForwarder;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanPermission;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.event.EventClientDelegateMBean;
import javax.management.event.EventClientNotFoundException;
import javax.management.event.EventForwarder;
import javax.management.event.EventSubscriber;
import javax.management.event.FetchingEventForwarder;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.NotificationResult;

public class EventClientDelegate
implements EventClientDelegateMBean {
    private final MBeanServer mbeanServer;
    private volatile String mbeanServerName = null;
    private Map<String, ClientInfo> clientInfoMap = new ConcurrentHashMap<String, ClientInfo>();
    private final CleanListener cleanListener = new CleanListener();
    private final EventSubscriber eventSubscriber;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "EventClientDelegate");
    private static final Map<MBeanServer, WeakReference<EventClientDelegate>> delegateMap = new WeakHashMap<MBeanServer, WeakReference<EventClientDelegate>>();

    private EventClientDelegate(MBeanServer mBeanServer) {
        if (mBeanServer == null) {
            throw new NullPointerException("Null MBeanServer.");
        }
        if (logger.traceOn()) {
            logger.trace("EventClientDelegate", "new one");
        }
        this.mbeanServer = mBeanServer;
        this.eventSubscriber = EventSubscriber.getEventSubscriber(this.mbeanServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventClientDelegate getEventClientDelegate(MBeanServer mBeanServer) {
        EventClientDelegate eventClientDelegate = null;
        Map<MBeanServer, WeakReference<EventClientDelegate>> map = delegateMap;
        synchronized (map) {
            WeakReference<EventClientDelegate> weakReference = delegateMap.get(mBeanServer);
            EventClientDelegate eventClientDelegate2 = eventClientDelegate = weakReference == null ? null : (EventClientDelegate)weakReference.get();
            if (eventClientDelegate == null) {
                eventClientDelegate = new EventClientDelegate(mBeanServer);
                try {
                    eventClientDelegate.mbeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, eventClientDelegate.cleanListener, null, null);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    logger.fine("getEventClientDelegate", "Could not add MBeanServerDelegate listener", instanceNotFoundException);
                }
                delegateMap.put(mBeanServer, new WeakReference<EventClientDelegate>(eventClientDelegate));
            }
        }
        return eventClientDelegate;
    }

    public static MBeanServerForwarder newForwarder(MBeanServer mBeanServer, MBeanServer mBeanServer2) {
        Forwarder forwarder = new Forwarder();
        if (mBeanServer2 == null) {
            mBeanServer2 = forwarder;
        }
        forwarder.setLoopMBS(mBeanServer2);
        if (mBeanServer != null) {
            forwarder.setMBeanServer(mBeanServer);
        }
        return forwarder;
    }

    public static EventClientDelegateMBean getProxy(MBeanServerConnection mBeanServerConnection) {
        return MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, OBJECT_NAME, EventClientDelegateMBean.class, false);
    }

    @Override
    public String addClient(String string, Object[] objectArray, String[] stringArray) throws MBeanException {
        return this.addClient(string, null, objectArray, stringArray, true);
    }

    @Override
    public String addClient(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws MBeanException {
        return this.addClient(string, objectName, objectArray, stringArray, false);
    }

    private String addClient(String string, ObjectName objectName, Object[] objectArray, String[] stringArray, boolean bl) throws MBeanException {
        try {
            return this.addClientX(string, objectName, objectArray, stringArray, bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MBeanException(exception);
        }
    }

    private String addClientX(String string, ObjectName objectName, Object[] objectArray, String[] stringArray, boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (string == null) {
            throw new IllegalArgumentException("Null class name.");
        }
        if (string.startsWith("javax.management.event.")) {
            object3 = Class.forName(string, false, this.getClass().getClassLoader());
            object2 = null;
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            for (Constructor<?> constructor : ((Class)object3).getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                Object[] objectArray2 = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    objectArray2[i] = classArray[i].getName();
                }
                if (!Arrays.equals(stringArray, objectArray2)) continue;
                object2 = constructor;
                break;
            }
            if (object2 == null) {
                throw new NoSuchMethodException("Constructor for " + string + " with argument types " + Arrays.toString(stringArray));
            }
            object = ((Constructor)object2).newInstance(objectArray);
        } else {
            object = bl ? this.mbeanServer.instantiate(string, objectArray, stringArray) : this.mbeanServer.instantiate(string, objectName, objectArray, stringArray);
        }
        if (!(object instanceof EventForwarder)) {
            throw new IllegalArgumentException(string + " is not an EventForwarder class.");
        }
        object3 = (EventForwarder)object;
        object2 = UUID.randomUUID().toString();
        ClientInfo clientInfo = new ClientInfo((String)object2, (EventForwarder)object3);
        this.clientInfoMap.put((String)object2, clientInfo);
        object3.setClientId((String)object2);
        if (logger.traceOn()) {
            logger.trace("addClient", (String)object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer[] getListenerIds(String string) throws IOException, EventClientNotFoundException {
        Map<Integer, AddedListener> map;
        ClientInfo clientInfo = this.getClientInfo(string);
        if (clientInfo == null) {
            throw new EventClientNotFoundException("The client is not found.");
        }
        Map<Integer, AddedListener> map2 = map = clientInfo.listenerInfoMap;
        synchronized (map2) {
            Set<Integer> set = map.keySet();
            return set.toArray(new Integer[set.size()]);
        }
    }

    @Override
    public Integer addListener(String string, ObjectName objectName, NotificationFilter notificationFilter) throws EventClientNotFoundException, InstanceNotFoundException {
        if (logger.traceOn()) {
            logger.trace("addListener", "");
        }
        return this.getClientInfo(string).addListenerInfo(objectName, notificationFilter);
    }

    @Override
    public void removeListenerOrSubscriber(String string, Integer n) throws InstanceNotFoundException, ListenerNotFoundException, EventClientNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeListener", "" + n);
        }
        this.getClientInfo(string).removeListenerInfo(n);
    }

    @Override
    public Integer addSubscriber(String string, ObjectName objectName, NotificationFilter notificationFilter) throws EventClientNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("addSubscriber", "");
        }
        return this.getClientInfo(string).subscribeListenerInfo(objectName, notificationFilter);
    }

    @Override
    public NotificationResult fetchNotifications(String string, long l, int n, long l2) throws EventClientNotFoundException {
        if (logger.traceOn()) {
            logger.trace("fetchNotifications", "for " + string);
        }
        return this.getClientInfo(string).fetchNotifications(l, n, l2);
    }

    @Override
    public void removeClient(String string) throws EventClientNotFoundException {
        if (string == null) {
            throw new EventClientNotFoundException("Null clientId");
        }
        if (logger.traceOn()) {
            logger.trace("removeClient", string);
        }
        ClientInfo clientInfo = null;
        clientInfo = this.clientInfoMap.remove(string);
        if (clientInfo == null) {
            throw new EventClientNotFoundException("clientId is " + string);
        }
        clientInfo.clean();
    }

    @Override
    public long lease(String string, long l) throws IOException, EventClientNotFoundException {
        if (logger.traceOn()) {
            logger.trace("lease", "for " + string);
        }
        return this.getClientInfo(string).lease(l);
    }

    private ClientInfo getClientInfo(String string) throws EventClientNotFoundException {
        ClientInfo clientInfo = null;
        clientInfo = this.clientInfoMap.get(string);
        if (clientInfo == null) {
            throw new EventClientNotFoundException("Client not found (id " + string + ")");
        }
        return clientInfo;
    }

    private boolean checkListenerPermission(final ObjectName objectName, AccessControlContext accessControlContext) {
        SecurityManager securityManager;
        if (logger.traceOn()) {
            logger.trace("checkListenerPermission", "");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = this.getMBeanServerName();
                ObjectInstance objectInstance = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException {
                        return EventClientDelegate.this.mbeanServer.getObjectInstance(objectName);
                    }
                });
                String string2 = objectInstance.getClassName();
                MBeanPermission mBeanPermission = new MBeanPermission(string, string2, null, objectName, "addNotificationListener");
                securityManager.checkPermission(mBeanPermission, accessControlContext);
            }
            catch (Exception exception) {
                if (logger.debugOn()) {
                    logger.debug("checkListenerPermission", "refused.", exception);
                }
                return false;
            }
        }
        return true;
    }

    private String getMBeanServerName() {
        if (this.mbeanServerName != null) {
            return this.mbeanServerName;
        }
        this.mbeanServerName = EventClientDelegate.getMBeanServerName(this.mbeanServer);
        return this.mbeanServerName;
    }

    private static String getMBeanServerName(final MBeanServer mBeanServer) {
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Util.getMBeanServerSecurityName(mBeanServer);
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    private class CleanListener
    implements NotificationListener {
        private CleanListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof MBeanServerNotification && "JMX.mbean.unregistered".equals(notification.getType())) {
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                Collection<ClientInfo> collection = Collections.unmodifiableCollection(EventClientDelegate.this.clientInfoMap.values());
                for (ClientInfo clientInfo : collection) {
                    clientInfo.clean(objectName);
                }
            }
        }
    }

    private class AddedListener {
        final int listenerId;
        final NotificationFilter filter;
        final ObjectName name;
        final boolean subscription;
        final AccessControlContext acc;

        public AddedListener(int n, NotificationFilter notificationFilter, ObjectName objectName, boolean bl) {
            this.listenerId = n;
            this.filter = notificationFilter;
            this.name = objectName;
            this.subscription = bl;
            this.acc = AccessController.getContext();
        }
    }

    private class ForwardingClientListener
    implements NotificationListener {
        private final Map<Integer, AddedListener> listenerInfoMap;
        private final EventForwarder forwarder;

        public ForwardingClientListener(Map<Integer, AddedListener> map, EventForwarder eventForwarder) {
            this.listenerInfoMap = map;
            this.forwarder = eventForwarder;
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            block5: {
                if (notification == null || !(object instanceof AddedListener)) {
                    if (logger.traceOn()) {
                        logger.trace("ForwardingClientListener-handleNotification", "received a unknown notif");
                    }
                    return;
                }
                AddedListener addedListener = (AddedListener)object;
                if (EventClientDelegate.this.checkListenerPermission(addedListener.name, addedListener.acc)) {
                    try {
                        this.forwarder.forward(notification, addedListener.listenerId);
                    }
                    catch (Exception exception) {
                        if (!logger.traceOn()) break block5;
                        logger.trace("ForwardingClientListener-handleNotification", "forwarding failed.", exception);
                    }
                }
            }
        }
    }

    private class ClientInfo {
        final String clientId;
        final NotificationListener clientListener;
        final Map<Integer, AddedListener> listenerInfoMap = new HashMap<Integer, AddedListener>();
        private final AtomicInteger nextListenerId = new AtomicInteger();
        private EventForwarder forwarder = null;
        private final Runnable leaseExpiryCallback = new Runnable(){

            @Override
            public void run() {
                try {
                    EventClientDelegate.this.removeClient(ClientInfo.this.clientId);
                }
                catch (Exception exception) {
                    logger.trace("ClientInfo.leaseExpiryCallback", "removeClient", exception);
                }
            }
        };
        private LeaseManager leaseManager = new LeaseManager(this.leaseExpiryCallback);

        ClientInfo(String string, EventForwarder eventForwarder) {
            this.clientId = string;
            this.forwarder = eventForwarder;
            this.clientListener = new ForwardingClientListener(this.listenerInfoMap, eventForwarder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Integer addOrSubscribeListenerInfo(ObjectName objectName, NotificationFilter notificationFilter, boolean bl) throws InstanceNotFoundException, IOException {
            Integer n = this.nextListenerId();
            AddedListener addedListener = new AddedListener(n, notificationFilter, objectName, bl);
            if (bl) {
                EventClientDelegate.this.eventSubscriber.subscribe(objectName, this.clientListener, notificationFilter, addedListener);
            } else {
                EventClientDelegate.this.mbeanServer.addNotificationListener(objectName, this.clientListener, notificationFilter, (Object)addedListener);
            }
            Map<Integer, AddedListener> map = this.listenerInfoMap;
            synchronized (map) {
                this.listenerInfoMap.put(n, addedListener);
            }
            return n;
        }

        Integer addListenerInfo(ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException {
            try {
                return this.addOrSubscribeListenerInfo(objectName, notificationFilter, false);
            }
            catch (IOException iOException) {
                logger.warning("EventClientDelegate.addListenerInfo", "unexpected exception", iOException);
                throw new RuntimeException(iOException);
            }
        }

        Integer subscribeListenerInfo(ObjectName objectName, NotificationFilter notificationFilter) throws IOException {
            try {
                return this.addOrSubscribeListenerInfo(objectName, notificationFilter, true);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                logger.warning("EventClientDelegate.subscribeListenerInfo", "unexpected exception", instanceNotFoundException);
                throw new RuntimeException(instanceNotFoundException);
            }
        }

        private Integer nextListenerId() {
            return this.nextListenerId.getAndIncrement();
        }

        NotificationResult fetchNotifications(long l, int n, long l2) {
            if (!(this.forwarder instanceof FetchingEventForwarder)) {
                throw new IllegalArgumentException("This client is using Event Postal Service!");
            }
            return ((FetchingEventForwarder)this.forwarder).fetchNotifications(l, n, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeListenerInfo(Integer n) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            AddedListener addedListener;
            Map<Integer, AddedListener> map = this.listenerInfoMap;
            synchronized (map) {
                addedListener = this.listenerInfoMap.remove(n);
            }
            if (addedListener == null) {
                throw new ListenerNotFoundException("The listener is not found.");
            }
            if (addedListener.subscription) {
                EventClientDelegate.this.eventSubscriber.unsubscribe(addedListener.name, this.clientListener);
            } else {
                EventClientDelegate.this.mbeanServer.removeNotificationListener(addedListener.name, this.clientListener, addedListener.filter, (Object)addedListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean(ObjectName objectName) {
            Map<Integer, AddedListener> map = this.listenerInfoMap;
            synchronized (map) {
                for (Map.Entry<Integer, AddedListener> entry : this.listenerInfoMap.entrySet()) {
                    AddedListener addedListener = entry.getValue();
                    if (!objectName.equals(addedListener.name)) continue;
                    this.listenerInfoMap.remove(entry.getKey());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clean() {
            Map<Integer, AddedListener> map = this.listenerInfoMap;
            synchronized (map) {
                for (AddedListener addedListener : this.listenerInfoMap.values()) {
                    try {
                        EventClientDelegate.this.mbeanServer.removeNotificationListener(addedListener.name, this.clientListener);
                    }
                    catch (Exception exception) {
                        logger.trace("ClientInfo.clean", "removeNL", exception);
                    }
                }
                this.listenerInfoMap.clear();
            }
            try {
                this.forwarder.close();
            }
            catch (Exception exception) {
                logger.trace("ClientInfo.clean", "forwarder.close", exception);
            }
            if (this.leaseManager != null) {
                this.leaseManager.stop();
            }
        }

        long lease(long l) {
            return this.leaseManager.lease(l);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof ClientInfo && this.clientId.equals(((ClientInfo)object).clientId);
        }

        public int hashCode() {
            return this.clientId.hashCode();
        }
    }

    private static class Forwarder
    extends SingleMBeanForwarder {
        private MBeanServer loopMBS;
        private volatile boolean madeECD;

        private static DynamicMBean makeUnsupportedECD() {
            EventClientDelegateMBean eventClientDelegateMBean = (EventClientDelegateMBean)Proxy.newProxyInstance(EventClientDelegateMBean.class.getClassLoader(), new Class[]{EventClientDelegateMBean.class}, new UnsupportedInvocationHandler());
            return new StandardMBean(eventClientDelegateMBean, EventClientDelegateMBean.class, false);
        }

        Forwarder() {
            super(EventClientDelegateMBean.OBJECT_NAME, Forwarder.makeUnsupportedECD(), true);
        }

        synchronized void setLoopMBS(MBeanServer mBeanServer) {
            this.loopMBS = mBeanServer;
        }

        @Override
        public synchronized void setMBeanServer(MBeanServer mBeanServer) {
            super.setMBeanServer(mBeanServer);
            if (!this.madeECD) {
                try {
                    EventClientDelegate eventClientDelegate = AccessController.doPrivileged(new PrivilegedAction<EventClientDelegate>(){

                        @Override
                        public EventClientDelegate run() {
                            return EventClientDelegate.getEventClientDelegate(Forwarder.this.loopMBS);
                        }
                    });
                    StandardMBean standardMBean = new StandardMBean(eventClientDelegate, EventClientDelegateMBean.class, false);
                    this.setSingleMBean(standardMBean);
                    this.madeECD = true;
                }
                catch (Exception exception) {
                    logger.fine("setMBeanServer", "isRegistered", exception);
                }
            }
        }

        private static class UnsupportedInvocationHandler
        implements InvocationHandler {
            private UnsupportedInvocationHandler() {
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                throw new UnsupportedOperationException("EventClientDelegate unavailable: no MBeanServer, or MBeanServer inaccessible");
            }
        }
    }
}

