/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Depth;
import sun.awt.X11.Native;
import sun.awt.X11.Visual;
import sun.awt.X11.XExtData;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class Screen
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 80;
    }

    @Override
    public int getDataSize() {
        return Screen.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public Screen(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public Screen() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(Screen.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public XExtData get_ext_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 0L) != 0L ? new XExtData(Native.getLong(this.pData + 0L) + (long)(n * 16)) : null;
    }

    public long get_ext_data() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_ext_data(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_display(int n) {
        log.finest("");
        return Native.getLong(this.pData + 4L) + (long)(n * Native.getLongSize());
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + 4L, l);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_root(long l) {
        log.finest("");
        Native.putLong(this.pData + 8L, l);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + 16L, n);
    }

    public int get_mwidth() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_mwidth(int n) {
        log.finest("");
        Native.putInt(this.pData + 20L, n);
    }

    public int get_mheight() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_mheight(int n) {
        log.finest("");
        Native.putInt(this.pData + 24L, n);
    }

    public int get_ndepths() {
        log.finest("");
        return Native.getInt(this.pData + 28L);
    }

    public void set_ndepths(int n) {
        log.finest("");
        Native.putInt(this.pData + 28L, n);
    }

    public Depth get_depths(int n) {
        log.finest("");
        return Native.getLong(this.pData + 32L) != 0L ? new Depth(Native.getLong(this.pData + 32L) + (long)(n * 12)) : null;
    }

    public long get_depths() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_depths(long l) {
        log.finest("");
        Native.putLong(this.pData + 32L, l);
    }

    public int get_root_depth() {
        log.finest("");
        return Native.getInt(this.pData + 36L);
    }

    public void set_root_depth(int n) {
        log.finest("");
        Native.putInt(this.pData + 36L, n);
    }

    public Visual get_root_visual(int n) {
        log.finest("");
        return Native.getLong(this.pData + 40L) != 0L ? new Visual(Native.getLong(this.pData + 40L) + (long)(n * 32)) : null;
    }

    public long get_root_visual() {
        log.finest("");
        return Native.getLong(this.pData + 40L);
    }

    public void set_root_visual(long l) {
        log.finest("");
        Native.putLong(this.pData + 40L, l);
    }

    public long get_default_gc() {
        log.finest("");
        return Native.getLong(this.pData + 44L);
    }

    public void set_default_gc(long l) {
        log.finest("");
        Native.putLong(this.pData + 44L, l);
    }

    public long get_cmap() {
        log.finest("");
        return Native.getLong(this.pData + 48L);
    }

    public void set_cmap(long l) {
        log.finest("");
        Native.putLong(this.pData + 48L, l);
    }

    public long get_white_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 52L);
    }

    public void set_white_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 52L, l);
    }

    public long get_black_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 56L);
    }

    public void set_black_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + 56L, l);
    }

    public int get_max_maps() {
        log.finest("");
        return Native.getInt(this.pData + 60L);
    }

    public void set_max_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + 60L, n);
    }

    public int get_min_maps() {
        log.finest("");
        return Native.getInt(this.pData + 64L);
    }

    public void set_min_maps(int n) {
        log.finest("");
        Native.putInt(this.pData + 64L, n);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + 68L);
    }

    public void set_backing_store(int n) {
        log.finest("");
        Native.putInt(this.pData + 68L, n);
    }

    public boolean get_save_unders() {
        log.finest("");
        return Native.getBool(this.pData + 72L);
    }

    public void set_save_unders(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + 72L, bl);
    }

    public long get_root_input_mask() {
        log.finest("");
        return Native.getLong(this.pData + 76L);
    }

    public void set_root_input_mask(long l) {
        log.finest("");
        Native.putLong(this.pData + 76L, l);
    }

    @Override
    String getName() {
        return "Screen";
    }

    @Override
    String getFieldsAsString() {
        String string = "";
        string = string + "ext_data = " + this.get_ext_data() + ", ";
        string = string + "display = " + this.get_display() + ", ";
        string = string + "root = " + this.get_root() + ", ";
        string = string + "width = " + this.get_width() + ", ";
        string = string + "height = " + this.get_height() + ", ";
        string = string + "mwidth = " + this.get_mwidth() + ", ";
        string = string + "mheight = " + this.get_mheight() + ", ";
        string = string + "ndepths = " + this.get_ndepths() + ", ";
        string = string + "depths = " + this.get_depths() + ", ";
        string = string + "root_depth = " + this.get_root_depth() + ", ";
        string = string + "root_visual = " + this.get_root_visual() + ", ";
        string = string + "default_gc = " + this.get_default_gc() + ", ";
        string = string + "cmap = " + this.get_cmap() + ", ";
        string = string + "white_pixel = " + this.get_white_pixel() + ", ";
        string = string + "black_pixel = " + this.get_black_pixel() + ", ";
        string = string + "max_maps = " + this.get_max_maps() + ", ";
        string = string + "min_maps = " + this.get_min_maps() + ", ";
        string = string + "backing_store = " + this.get_backing_store() + ", ";
        string = string + "save_unders = " + this.get_save_unders() + ", ";
        string = string + "root_input_mask = " + this.get_root_input_mask() + ", ";
        return string;
    }
}

