/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.jkernel.BackgroundDownloader;
import sun.jkernel.Bundle;
import sun.jkernel.BundleCheck;
import sun.jkernel.KernelError;
import sun.misc.Launcher;

public class DownloadManager {
    public static final String KERNEL_DOWNLOAD_URL_PROPERTY = "kernel.download.url";
    public static final String KERNEL_DOWNLOAD_ENABLED_PROPERTY = "kernel.download.enabled";
    public static final String KERNEL_DOWNLOAD_DIALOG_PROPERTY = "kernel.download.dialog";
    public static final String KERNEL_DEBUG_PROPERTY = "kernel.debug";
    public static final String KERNEL_NOMERGE_PROPERTY = "kernel.nomerge";
    public static final String KERNEL_SIMULTANEOUS_DOWNLOADS_PROPERTY = "kernel.simultaneous.downloads";
    public static final int KERNEL_STATIC_MODTIME = 10000000;
    public static final String RESOURCE_URL = "internal-resource/";
    public static final String REQUESTED_BUNDLES_PATH = "lib" + File.separator + "bundles" + File.separator + "requested.list";
    private static final boolean disableDownloadDialog = "false".equals(System.getProperty("kernel.download.dialog"));
    static boolean debug = "true".equals(System.getProperty("kernel.debug"));
    private static OutputStream errorStream;
    private static OutputStream logStream;
    static String MUTEX_PREFIX;
    static boolean complete;
    private static int _isJBrokerStarted;
    private static Properties bundleURLs;
    public static final String JAVA_HOME;
    public static final String USER_HOME;
    public static final String JAVA_VERSION;
    static final int BUFFER_SIZE = 2048;
    static volatile boolean jkernelLibLoaded;
    public static String DEFAULT_DOWNLOAD_URL;
    private static final String CUSTOM_PREFIX = "custom";
    private static final String KERNEL_PATH_SUFFIX = "-kernel";
    public static final String JAR_PATH_PROPERTY = "jarpath";
    public static final String SIZE_PROPERTY = "size";
    public static final String DEPENDENCIES_PROPERTY = "dependencies";
    public static final String INSTALL_PROPERTY = "install";
    private static boolean reportErrors;
    static final int ERROR_UNSPECIFIED = 0;
    static final int ERROR_DISK_FULL = 1;
    static final int ERROR_MALFORMED_BUNDLE_PROPERTIES = 2;
    static final int ERROR_DOWNLOADING_BUNDLE_PROPERTIES = 3;
    static final int ERROR_MALFORMED_URL = 4;
    static final int ERROR_RETRY_CANCELLED = 5;
    static final int ERROR_NO_SUCH_BUNDLE = 6;
    static ThreadLocal<Integer> downloading;
    private static File[] additionalBootStrapPaths;
    private static String[] bundleNames;
    private static String[] criticalBundleNames;
    private static String downloadURL;
    private static boolean visitorIdDetermined;
    private static String visitorId;
    public static String CHECK_VALUES_FILE;
    static String CHECK_VALUES_DIR;
    static String CHECK_VALUES_PATH;
    private static Map<String, Map<String, String>> bundleProperties;
    private static Map<String, String> resourceMap;
    private static Map<String, String> fileMap;
    private static boolean extDirDetermined;
    private static boolean extDirIncluded;

    static synchronized void loadJKernelLibrary() {
        if (!jkernelLibLoaded) {
            try {
                System.loadLibrary("jkernel");
                jkernelLibLoaded = true;
                debug = DownloadManager.getDebugProperty();
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    static String appendTransactionId(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = DownloadManager.getVisitorId();
        if (string2 != null) {
            if (string.indexOf("?") == -1) {
                stringBuilder.append('?');
            } else {
                stringBuilder.append('&');
            }
            stringBuilder.append("transactionId=");
            stringBuilder.append(DownloadManager.getVisitorId());
        }
        return stringBuilder.toString();
    }

    static synchronized String getBaseDownloadURL() {
        if (downloadURL == null) {
            DownloadManager.log("Determining download URL...");
            DownloadManager.loadJKernelLibrary();
            downloadURL = System.getProperty(KERNEL_DOWNLOAD_URL_PROPERTY);
            DownloadManager.log("System property kernel.download.url = " + downloadURL);
            if (downloadURL == null) {
                downloadURL = DownloadManager.getUrlFromRegistry();
                DownloadManager.log("getUrlFromRegistry = " + downloadURL);
            }
            if (downloadURL == null) {
                downloadURL = DEFAULT_DOWNLOAD_URL;
            }
            DownloadManager.log("Final download URL: " + downloadURL);
        }
        return downloadURL;
    }

    static Map<String, String> readTreeMap(InputStream inputStream) throws IOException {
        int n;
        HashMap hashMap = new HashMap();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            if (n < 32) {
                if (arrayList.size() > 0) {
                    arrayList.set(arrayList.size() - 1, stringBuilder.toString());
                }
                stringBuilder.setLength(0);
                if (n > arrayList.size()) {
                    throw new InternalError("current token level is " + (arrayList.size() - 1) + " but encountered token " + "level " + n);
                }
                if (n == arrayList.size()) {
                    arrayList.add(null);
                    continue;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (int i = 1; i < arrayList.size(); ++i) {
                    if (i > 1) {
                        stringBuilder2.append('/');
                    }
                    stringBuilder2.append((String)arrayList.get(i));
                }
                hashMap.put(stringBuilder2.toString(), arrayList.get(0));
                while (n < arrayList.size()) {
                    arrayList.remove(n);
                }
                arrayList.add(null);
                continue;
            }
            if (n < 254) {
                stringBuilder.append((char)n);
                continue;
            }
            if (n == 255) {
                stringBuilder.append(".class");
                continue;
            }
            throw new InternalError("internal error processing resource_map (can't-happen error)");
        }
        if (arrayList.size() > 0) {
            arrayList.set(arrayList.size() - 1, stringBuilder.toString());
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        for (int i = 1; i < arrayList.size(); ++i) {
            if (i > 1) {
                stringBuilder3.append('/');
            }
            stringBuilder3.append((String)arrayList.get(i));
        }
        if (!arrayList.isEmpty()) {
            hashMap.put(stringBuilder3.toString(), arrayList.get(0));
        }
        ((InputStream)bufferedInputStream).close();
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map<String, String> getResourceMap() throws IOException {
        if (resourceMap == null) {
            InputStream inputStream = DownloadManager.class.getResourceAsStream("resource_map");
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
                try {
                    resourceMap = DownloadManager.readTreeMap(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    resourceMap = new HashMap<String, String>();
                    complete = true;
                    DownloadManager.log("Can't find resource_map, forcing complete to true");
                }
                inputStream.close();
            } else {
                resourceMap = new HashMap<String, String>();
                complete = true;
                DownloadManager.log("Can't find resource_map, forcing complete to true");
            }
            int n = 1;
            while (true) {
                String string = CUSTOM_PREFIX + n;
                File file = new File(DownloadManager.getBundlePath(), string + ".jar");
                if (!file.exists()) break;
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    resourceMap.put(jarEntry.getName(), string);
                }
                ++n;
            }
        }
        return resourceMap;
    }

    public static Map<String, String> getFileMap() throws IOException {
        if (fileMap == null) {
            InputStream inputStream = DownloadManager.class.getResourceAsStream("file_map");
            if (inputStream != null) {
                inputStream = new BufferedInputStream(inputStream);
                try {
                    fileMap = DownloadManager.readTreeMap(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {
                    fileMap = new HashMap<String, String>();
                    complete = true;
                    DownloadManager.log("Can't find file_map, forcing complete to true");
                }
                inputStream.close();
            } else {
                fileMap = new HashMap<String, String>();
                complete = true;
                DownloadManager.log("Can't find file_map, forcing complete to true");
            }
        }
        return fileMap;
    }

    private static synchronized Map<String, Map<String, String>> getBundleProperties() throws IOException {
        if (bundleProperties == null) {
            InputStream inputStream = DownloadManager.class.getResourceAsStream("bundle.properties");
            if (inputStream == null) {
                complete = true;
                DownloadManager.log("Can't find bundle.properties, forcing complete to true");
                return null;
            }
            inputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            properties.load(inputStream);
            bundleProperties = new HashMap<String, Map<String, String>>();
            for (Map.Entry entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                String[] stringArray = ((String)entry.getValue()).split("\\|");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String string2 : stringArray) {
                    int n = string2.indexOf("=");
                    if (n == -1) {
                        throw new InternalError("error parsing bundle.properties: " + string2);
                    }
                    hashMap.put(string2.substring(0, n).trim(), string2.substring(n + 1).trim());
                }
                bundleProperties.put(string, hashMap);
            }
            inputStream.close();
        }
        return bundleProperties;
    }

    static String getBundleProperty(String string, String string2) {
        try {
            Map<String, Map<String, String>> map = DownloadManager.getBundleProperties();
            Map<String, String> map2 = map != null ? map.get(string) : null;
            return map2 != null ? map2.get(string2) : null;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static String[] getBundleNames() throws IOException {
        if (bundleNames == null) {
            Map<String, String> map;
            HashSet<String> hashSet = new HashSet<String>();
            Map<String, String> map2 = DownloadManager.getResourceMap();
            if (map2 != null) {
                hashSet.addAll(map2.values());
            }
            if ((map = DownloadManager.getFileMap()) != null) {
                hashSet.addAll(map.values());
            }
            bundleNames = hashSet.toArray(new String[hashSet.size()]);
        }
        return bundleNames;
    }

    private static String[] getCriticalBundleNames() throws IOException {
        if (criticalBundleNames == null) {
            HashSet<String> hashSet = new HashSet<String>();
            Map<String, String> map = DownloadManager.getFileMap();
            if (map != null) {
                hashSet.addAll(map.values());
            }
            criticalBundleNames = hashSet.toArray(new String[hashSet.size()]);
        }
        return criticalBundleNames;
    }

    public static void send(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    static void performCompletionIfNeeded() {
        if (debug) {
            DownloadManager.log("DownloadManager.performCompletionIfNeeded: checking (" + complete + ", " + System.getProperty(KERNEL_NOMERGE_PROPERTY) + ")");
        }
        if (complete || "true".equals(System.getProperty(KERNEL_NOMERGE_PROPERTY))) {
            return;
        }
        Bundle.loadReceipts();
        try {
            if (debug) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(DownloadManager.getCriticalBundleNames()));
                arrayList.removeAll(Bundle.receipts);
                DownloadManager.log("DownloadManager.performCompletionIfNeeded: still need " + arrayList.size() + " bundles (" + arrayList + ")");
            }
            if (Bundle.receipts.containsAll(Arrays.asList(DownloadManager.getCriticalBundleNames()))) {
                DownloadManager.log("DownloadManager.performCompletionIfNeeded: running");
                new Thread("JarMerger"){

                    @Override
                    public void run() {
                        DownloadManager.createMergedJars();
                    }
                }.start();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Bundle getBundleForResource(String string) throws IOException {
        String string2 = DownloadManager.getResourceMap().get(string);
        return string2 != null ? Bundle.getBundle(string2) : null;
    }

    private static Bundle getBundleForFile(String string) throws IOException {
        String string2 = DownloadManager.getFileMap().get(string);
        return string2 != null ? Bundle.getBundle(string2) : null;
    }

    static File getBundlePath() {
        return new File(JAVA_HOME, "lib" + File.separatorChar + "bundles");
    }

    private static String getAppDataLocalLow() {
        return USER_HOME + "\\appdata\\locallow\\";
    }

    public static String getKernelJREDir() {
        return "kerneljre" + JAVA_VERSION;
    }

    static File getLocalLowTempBundlePath() {
        return new File(DownloadManager.getLocalLowKernelJava() + "-bundles");
    }

    static String getLocalLowKernelJava() {
        return DownloadManager.getAppDataLocalLow() + DownloadManager.getKernelJREDir();
    }

    public static synchronized File[] getAdditionalBootStrapPaths() {
        return additionalBootStrapPaths != null ? additionalBootStrapPaths : new File[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntryToBootClassPath(File file) {
        Class<Launcher> clazz = Launcher.class;
        synchronized (Launcher.class) {
            Class<DownloadManager> clazz2 = DownloadManager.class;
            synchronized (DownloadManager.class) {
                File[] fileArray = new File[additionalBootStrapPaths.length + 1];
                System.arraycopy(additionalBootStrapPaths, 0, fileArray, 0, additionalBootStrapPaths.length);
                fileArray[fileArray.length - 1] = file;
                additionalBootStrapPaths = fileArray;
                Launcher.flushBootstrapClassPath();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    private static synchronized boolean extDirIsIncluded() {
        if (!extDirDetermined) {
            extDirDetermined = true;
            String string = System.getProperty("java.ext.dirs");
            String string2 = JAVA_HOME + File.separator + "lib" + File.separator + "ext";
            int n = 0;
            while (n < string.length()) {
                String string3;
                int n2 = string.indexOf(File.pathSeparator, n);
                if (n2 == -1) {
                    n2 = string.length();
                }
                if ((string3 = string.substring(n, n2)).equals(string2)) {
                    extDirIncluded = true;
                    break;
                }
                n = n2 + 1;
            }
        }
        return extDirIncluded;
    }

    private static String doGetBootClassPathEntryForResource(String string) {
        boolean bl = false;
        while (true) {
            Bundle bundle = null;
            try {
                bundle = DownloadManager.getBundleForResource(string);
                if (bundle != null) {
                    Bundle bundle2;
                    File file = bundle.getJarPath();
                    boolean bl2 = file.getParentFile().getName().equals("ext");
                    if (bl2 && !DownloadManager.extDirIsIncluded()) {
                        return null;
                    }
                    if (DownloadManager.getBundleProperty(bundle.getName(), JAR_PATH_PROPERTY) == null && (bundle2 = Bundle.getBundle("merged")) != null && bundle2.isInstalled()) {
                        File file2 = string.endsWith(".class") ? bundle2.getJarPath() : new File(bundle2.getJarPath().getPath().replaceAll("merged-rt.jar", "merged-resources.jar"));
                        DownloadManager.addEntryToBootClassPath(file2);
                        return file2.getPath();
                    }
                    if (!bundle.isInstalled()) {
                        bundle.queueDependencies(true);
                        DownloadManager.log("On-demand downloading " + bundle.getName() + " for resource " + string + "...");
                        bundle.install();
                        DownloadManager.log(bundle + " install finished.");
                    }
                    DownloadManager.log("Double-checking " + bundle + " state...");
                    if (!bundle.isInstalled()) {
                        throw new IllegalStateException("Expected state of " + bundle + " to be INSTALLED");
                    }
                    if (bl2) {
                        Launcher.addURLToExtClassLoader(file.toURL());
                        return null;
                    }
                    if ("javaws".equals(bundle.getName())) {
                        Launcher.addURLToAppClassLoader(file.toURL());
                        DownloadManager.log("Returning null for javaws");
                        return null;
                    }
                    if ("core".equals(bundle.getName())) {
                        return null;
                    }
                    DownloadManager.addEntryToBootClassPath(file);
                    return file.getPath();
                }
                return null;
            }
            catch (Throwable throwable) {
                bl = DownloadManager.handleException(throwable);
                DownloadManager.log("Error downloading bundle for " + string + ":");
                DownloadManager.log(throwable);
                if (!(throwable instanceof IOException) || bundle == null) continue;
                if (bundle.getJarPath() != null) {
                    File file = new File(bundle.getJarPath() + ".pack");
                    file.delete();
                    bundle.getJarPath().delete();
                }
                if (bundle.getLocalPath() != null) {
                    bundle.getLocalPath().delete();
                }
                bundle.setState(0);
                if (bl) continue;
                DownloadManager.sendErrorPing(5);
                return null;
            }
            break;
        }
    }

    static synchronized void sendErrorPing(int n) {
        try {
            Closeable closeable;
            File file = DownloadManager.isWindowsVista() ? DownloadManager.getLocalLowTempBundlePath() : DownloadManager.getBundlePath();
            File file2 = new File(file, "tmp");
            File file3 = new File(file2, "errors");
            String string = String.valueOf(n);
            if (file3.exists()) {
                closeable = new BufferedReader(new FileReader(file3));
                String string2 = ((BufferedReader)closeable).readLine();
                while (string2 != null) {
                    if (string2.equals(string)) {
                        return;
                    }
                    string2 = ((BufferedReader)closeable).readLine();
                }
            }
            file2.mkdirs();
            closeable = new FileWriter(file3, true);
            ((Writer)closeable).write(string + System.getProperty("line.separator"));
            ((Writer)closeable).close();
            DownloadManager.postDownloadError(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static boolean handleException(Throwable throwable) {
        if (throwable instanceof IOException) {
            int n = 0;
            if (throwable.getMessage().indexOf("not enough space") != -1) {
                n = 1;
            }
            return DownloadManager.askUserToRetryDownloadOrQuit(n);
        }
        return false;
    }

    static synchronized void flushBundleURLs() {
        bundleURLs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Properties getBundleURLs(boolean bl) throws IOException {
        if (bundleURLs == null) {
            DownloadManager.log("Entering DownloadManager.getBundleURLs");
            String string = DownloadManager.getBaseDownloadURL();
            String string2 = DownloadManager.appendTransactionId(string);
            File file = null;
            file = DownloadManager.isWindowsVista() ? DownloadManager.getLocalLowTempBundlePath() : DownloadManager.getBundlePath();
            File file2 = new File(file, "urls." + DownloadManager.getCurrentProcessId() + ".properties");
            try {
                DownloadManager.log("Downloading from " + string2 + " to " + file2);
                DownloadManager.downloadFromURL(string2, file2, "", bl);
                bundleURLs = new Properties();
                if (file2.exists()) {
                    DownloadManager.addToTotalDownloadSize((int)file2.length());
                    InputStream inputStream = new FileInputStream(file2);
                    inputStream = new BufferedInputStream(inputStream);
                    bundleURLs.load(inputStream);
                    inputStream.close();
                    if (bundleURLs.isEmpty()) {
                        DownloadManager.fatalError(2);
                    }
                } else {
                    DownloadManager.fatalError(3);
                }
            }
            finally {
                if (!debug) {
                    file2.delete();
                }
            }
            DownloadManager.log("Leaving DownloadManager.getBundleURLs");
        }
        return bundleURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBootClassPathEntryForResource(final String string) {
        if (debug) {
            DownloadManager.log("Entering getBootClassPathEntryForResource(" + string + ")");
        }
        if (DownloadManager.isJREComplete() || downloading == null || string.startsWith("sun/jkernel")) {
            if (debug) {
                DownloadManager.log("Bailing: " + DownloadManager.isJREComplete() + ", " + (downloading == null));
            }
            return null;
        }
        DownloadManager.incrementDownloadCount();
        try {
            String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return DownloadManager.doGetBootClassPathEntryForResource(string);
                }
            });
            DownloadManager.log("getBootClassPathEntryForResource(" + string + ") == " + string2);
            String string3 = string2;
            return string3;
        }
        finally {
            DownloadManager.decrementDownloadCount();
        }
    }

    public static String getBootClassPathEntryForClass(String string) {
        return DownloadManager.getBootClassPathEntryForResource(string.replace('.', '/') + ".class");
    }

    private static boolean doDownloadFile(String string) throws IOException {
        Bundle bundle = DownloadManager.getBundleForFile(string);
        if (bundle != null) {
            bundle.queueDependencies(true);
            DownloadManager.log("On-demand downloading " + bundle.getName() + " for file " + string + "...");
            bundle.install();
            return true;
        }
        return false;
    }

    public static boolean downloadFile(final String string) throws IOException {
        if (DownloadManager.isJREComplete() || downloading == null) {
            return false;
        }
        DownloadManager.incrementDownloadCount();
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File file = new File(JAVA_HOME, string.replace('/', File.separatorChar));
                    if (file.exists()) {
                        return true;
                    }
                    try {
                        return new Boolean(DownloadManager.doDownloadFile(string));
                    }
                    catch (IOException iOException) {
                        return iOException;
                    }
                }
            });
            if (t instanceof Boolean) {
                boolean bl = (Boolean)t;
                return bl;
            }
            throw (IOException)t;
        }
        finally {
            DownloadManager.decrementDownloadCount();
        }
    }

    static void incrementDownloadCount() {
        downloading.set(downloading.get() + 1);
    }

    static void decrementDownloadCount() {
        downloading.set(downloading.get() - 1);
    }

    public static boolean isCurrentThreadDownloading() {
        return downloading != null ? downloading.get() > 0 : false;
    }

    public static boolean isJREComplete() {
        return complete;
    }

    static void doBackgroundDownloads(boolean bl) {
        if (!complete) {
            if (!bl && !debug) {
                reportErrors = false;
            }
            try {
                Bundle bundle = Bundle.getBundle("javax_swing_core");
                if (!bundle.isInstalled()) {
                    bundle.install(bl, false, false);
                }
                for (String string : DownloadManager.getCriticalBundleNames()) {
                    Bundle bundle2 = Bundle.getBundle(string);
                    if (bundle2.isInstalled()) continue;
                    bundle2.install(bl, false, true);
                }
                DownloadManager.shutdown();
            }
            catch (IOException iOException) {
                DownloadManager.log(iOException);
            }
        }
    }

    static void copyReceiptFile(File file, File file2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        String string = dataInputStream.readLine();
        while (string != null) {
            ((OutputStream)fileOutputStream).write((string + '\n').getBytes("utf-8"));
            string = dataInputStream.readLine();
        }
        dataInputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    private static void downloadRequestedBundles() {
        DownloadManager.log("Checking for requested bundles...");
        try {
            File file = new File(JAVA_HOME, REQUESTED_BUNDLES_PATH);
            if (file.exists()) {
                int n;
                FileInputStream fileInputStream = new FileInputStream(file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DownloadManager.send(fileInputStream, byteArrayOutputStream);
                fileInputStream.close();
                String string = new String(byteArrayOutputStream.toByteArray(), "utf-8");
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                for (n = 0; n < string.length(); ++n) {
                    char c = string.charAt(n);
                    if (c == ',' || Character.isWhitespace(c)) {
                        if (stringBuilder.length() <= 0) continue;
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        continue;
                    }
                    stringBuilder.append(c);
                }
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                }
                DownloadManager.log("Requested bundles: " + arrayList);
                for (n = 0; n < arrayList.size(); ++n) {
                    Bundle bundle = Bundle.getBundle((String)arrayList.get(n));
                    if (bundle == null || bundle.isInstalled()) continue;
                    DownloadManager.log("Downloading " + bundle + " due to requested.list");
                    bundle.install(true, false, false);
                }
            }
        }
        catch (IOException iOException) {
            DownloadManager.log(iOException);
        }
    }

    static void fatalError(int n) {
        DownloadManager.fatalError(n, null);
    }

    static void fatalError(int n, String string) {
        int n2;
        DownloadManager.sendErrorPing(n);
        for (n2 = 0; n2 < Bundle.THREADS; ++n2) {
            DownloadManager.bundleInstallComplete();
        }
        if (reportErrors) {
            DownloadManager.displayError(n, string);
        }
        n2 = Boolean.getBoolean("java.awt.headless") || System.getProperty("javaplugin.version") != null ? 1 : 0;
        KernelError kernelError = new KernelError("Java Kernel bundle download failed");
        if (n2 != 0) {
            throw kernelError;
        }
        DownloadManager.log(kernelError);
        System.exit(1);
    }

    private static void startBackgroundDownloadWithBroker() {
        if (!BackgroundDownloader.getBackgroundDownloadProperty()) {
            return;
        }
        if (!DownloadManager.launchBrokerProcess()) {
            return;
        }
        String string = DownloadManager.getBaseDownloadURL();
        if (string == null || string.equals(DEFAULT_DOWNLOAD_URL)) {
            String string2 = " ";
        } else {
            String string3 = string;
        }
        DownloadManager.startBackgroundDownloadWithBrokerImpl(string);
    }

    private static void startBackgroundDownloads() {
        if (!complete && BackgroundDownloader.getBackgroundMutex().acquire(0)) {
            BackgroundDownloader.getBackgroundMutex().release();
            if (DownloadManager.isWindowsVista()) {
                DownloadManager.startBackgroundDownloadWithBroker();
            } else {
                BackgroundDownloader.startBackgroundDownloads();
            }
        }
    }

    static native void addToTotalDownloadSize(int var0);

    static void downloadFromURL(String string, File file, String string2, boolean bl) {
        DownloadManager.downloadFromURLImpl(string, file, string2, disableDownloadDialog ? false : bl);
    }

    private static native void downloadFromURLImpl(String var0, File var1, String var2, boolean var3);

    static native String getUrlFromRegistry();

    static native String getVisitorId0();

    static native void postDownloadComplete();

    static native void postDownloadError(int var0);

    static synchronized String getVisitorId() {
        if (!visitorIdDetermined) {
            visitorIdDetermined = true;
            visitorId = DownloadManager.getVisitorId0();
        }
        return visitorId;
    }

    public static native void displayError(int var0, String var1);

    public static native boolean askUserToRetryDownloadOrQuit(int var0);

    static native boolean isWindowsVista();

    private static native void startBackgroundDownloadWithBrokerImpl(String var0);

    private static int isJBrokerStarted() {
        if (_isJBrokerStarted == -1) {
            _isJBrokerStarted = DownloadManager.isJBrokerRunning() ? 1 : 0;
        }
        return _isJBrokerStarted;
    }

    private static native boolean isJBrokerRunning();

    private static native boolean isIEProtectedMode();

    private static native boolean launchJBroker(String var0);

    static native void bundleInstallStart();

    static native void bundleInstallComplete();

    private static native boolean moveFileWithBrokerImpl(String var0, String var1);

    private static native boolean moveDirWithBrokerImpl(String var0, String var1);

    static boolean moveFileWithBroker(String string) {
        if (!DownloadManager.launchBrokerProcess()) {
            return false;
        }
        return DownloadManager.moveFileWithBrokerImpl(string, USER_HOME);
    }

    static boolean moveDirWithBroker(String string) {
        if (!DownloadManager.launchBrokerProcess()) {
            return false;
        }
        return DownloadManager.moveDirWithBrokerImpl(string, USER_HOME);
    }

    private static synchronized boolean launchBrokerProcess() {
        if (DownloadManager.isJBrokerStarted() == 0) {
            boolean bl = DownloadManager.launchJBroker(JAVA_HOME);
            _isJBrokerStarted = bl ? 1 : 0;
            return bl;
        }
        return true;
    }

    private static void copyAll(File file, File file2, Set set) throws IOException {
        if (!set.contains(file.getName())) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        DownloadManager.copyAll(fileArray[i], new File(file2, fileArray[i].getName()), set);
                    }
                }
            } else {
                file2.getParentFile().mkdirs();
                FileInputStream fileInputStream = new FileInputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                DownloadManager.send(fileInputStream, fileOutputStream);
                fileInputStream.close();
                fileOutputStream.close();
            }
        }
    }

    public static void dumpOutput(final Process process) {
        Thread thread = new Thread("outputReader"){

            @Override
            public void run() {
                try {
                    InputStream inputStream = process.getInputStream();
                    DownloadManager.send(inputStream, System.out);
                }
                catch (IOException iOException) {
                    DownloadManager.log(iOException);
                }
            }
        };
        thread.start();
        Thread thread2 = new Thread("errorReader"){

            @Override
            public void run() {
                try {
                    InputStream inputStream = process.getErrorStream();
                    DownloadManager.send(inputStream, System.err);
                }
                catch (IOException iOException) {
                    DownloadManager.log(iOException);
                }
            }
        };
        thread2.start();
    }

    private static void createMergedJars() {
        DownloadManager.log("DownloadManager.createMergedJars");
        File file = DownloadManager.isWindowsVista() ? DownloadManager.getLocalLowTempBundlePath() : DownloadManager.getBundlePath();
        File file2 = new File(file, "tmp");
        if (new File(DownloadManager.getBundlePath(), "tmp" + File.separator + "finished").exists()) {
            return;
        }
        DownloadManager.log("DownloadManager.createMergedJars: running");
        file2.mkdirs();
        boolean bl = false;
        do {
            try {
                Bundle.getBundle("merged").install(false, false, true);
                DownloadManager.postDownloadComplete();
                File file3 = new File(file2, "finished");
                new FileOutputStream(file3).close();
                if (DownloadManager.isWindowsVista() && !DownloadManager.moveFileWithBroker(DownloadManager.getKernelJREDir() + "-bundles\\tmp\\finished")) {
                    throw new IOException("unable to create 'finished' file");
                }
                DownloadManager.log("DownloadManager.createMergedJars: created " + file3);
                if (!DownloadManager.isWindowsVista()) continue;
                File file4 = DownloadManager.getLocalLowTempBundlePath();
                File[] fileArray = file4.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        fileArray[i].delete();
                    }
                }
                file4.delete();
                DownloadManager.log("Finished cleanup, " + file4 + ".exists(): " + file4.exists());
            }
            catch (IOException iOException) {
                DownloadManager.log(iOException);
            }
        } while (bl);
        DownloadManager.log("DownloadManager.createMergedJars: finished");
    }

    private static void shutdown() {
        try {
            ExecutorService executorService = Bundle.getThreadPool();
            executorService.shutdown();
            executorService.awaitTermination(86400L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static native boolean getDebugKey();

    public static boolean getDebugProperty() {
        boolean bl = DownloadManager.getDebugKey();
        if (System.getProperty(KERNEL_DEBUG_PROPERTY) != null) {
            bl = Boolean.valueOf(System.getProperty(KERNEL_DEBUG_PROPERTY));
        }
        return bl;
    }

    static void println(String string) {
        if (System.err != null) {
            System.err.println(string);
        } else {
            try {
                if (errorStream == null) {
                    errorStream = new FileOutputStream(FileDescriptor.err);
                }
                errorStream.write((string + System.getProperty("line.separator")).getBytes("utf-8"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    static void log(String string) {
        if (debug) {
            DownloadManager.println(string);
            try {
                if (logStream == null) {
                    DownloadManager.loadJKernelLibrary();
                    File file = DownloadManager.isWindowsVista() ? DownloadManager.getLocalLowTempBundlePath() : DownloadManager.getBundlePath();
                    file = new File(file, "kernel." + DownloadManager.getCurrentProcessId() + ".log");
                    logStream = new FileOutputStream(file);
                }
                logStream.write((string + System.getProperty("line.separator")).getBytes("utf-8"));
                logStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void log(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.close();
        DownloadManager.log(byteArrayOutputStream.toString(0));
    }

    private static void printMap(Map map) {
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            Integer n2;
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            System.out.println(string + ": " + string2);
            Integer n3 = System.identityHashCode(string);
            if (!hashSet.contains(n3)) {
                hashSet.add(n3);
                n += string.length();
            }
            if (hashSet.contains(n2 = Integer.valueOf(System.identityHashCode(string2)))) continue;
            hashSet.add(n2);
            n += string2.length();
        }
        System.out.println(n + " bytes");
    }

    private static void dumpMaps() throws IOException {
        System.out.println("Resources:");
        System.out.println("----------");
        DownloadManager.printMap(DownloadManager.getResourceMap());
        System.out.println();
        System.out.println("Files:");
        System.out.println("----------");
        DownloadManager.printMap(DownloadManager.getFileMap());
    }

    private static void processDownload(String string) throws IOException {
        if (string.equals("all")) {
            debug = true;
            DownloadManager.doBackgroundDownloads(true);
            DownloadManager.performCompletionIfNeeded();
        } else {
            Bundle bundle = Bundle.getBundle(string);
            if (bundle == null) {
                DownloadManager.println("Unknown bundle: " + string);
                System.exit(1);
            } else {
                bundle.install();
            }
        }
    }

    static native int getCurrentProcessId();

    public static void main(String[] stringArray) throws Exception {
        AccessController.checkPermission(new AllPermission());
        boolean bl = false;
        if (stringArray.length == 2 && stringArray[0].equals("-install")) {
            File file;
            bl = true;
            Bundle bundle = new Bundle(){

                @Override
                protected void updateState() {
                    this.state = 2;
                }
            };
            int n = 0;
            while ((file = new File(DownloadManager.getBundlePath(), CUSTOM_PREFIX + ++n + ".jar")).exists()) {
            }
            bundle.setName(CUSTOM_PREFIX + n);
            bundle.setLocalPath(new File(stringArray[1]));
            bundle.setJarPath(file);
            bundle.setDeleteOnInstall(false);
            bundle.install();
        } else if (stringArray.length == 2 && stringArray[0].equals("-download")) {
            bl = true;
            DownloadManager.processDownload(stringArray[1]);
        } else if (stringArray.length == 1 && stringArray[0].equals("-dumpmaps")) {
            bl = true;
            DownloadManager.dumpMaps();
        } else if (stringArray.length == 2 && stringArray[0].equals("-sha1")) {
            bl = true;
            System.out.println(BundleCheck.getInstance(new File(stringArray[1])));
        } else if (stringArray.length == 1 && stringArray[0].equals("-downloadtest")) {
            bl = true;
            File file = File.createTempFile("download", ".test");
            while (true) {
                file.delete();
                DownloadManager.downloadFromURL(DownloadManager.getBaseDownloadURL(), file, "URLS", true);
                System.out.println("Downloaded " + file.length() + " bytes");
            }
        }
        if (!bl) {
            System.out.println("usage: DownloadManager -install <path>.zip |");
            System.out.println("       DownloadManager -download <bundle_name> |");
            System.out.println("       DownloadManager -dumpmaps");
            System.exit(1);
        }
    }

    static {
        _isJBrokerStarted = -1;
        JAVA_HOME = System.getProperty("java.home");
        USER_HOME = System.getProperty("user.home");
        JAVA_VERSION = System.getProperty("java.version");
        jkernelLibLoaded = false;
        DEFAULT_DOWNLOAD_URL = "http://javadl.sun.com/webapps/download/GetList/" + System.getProperty("java.runtime.version") + "-kernel/windows-i586/";
        reportErrors = true;
        downloading = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        additionalBootStrapPaths = new File[0];
        CHECK_VALUES_FILE = "check_value.properties";
        CHECK_VALUES_DIR = "sun/jkernel/";
        CHECK_VALUES_PATH = CHECK_VALUES_DIR + CHECK_VALUES_FILE;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (debug) {
                    DownloadManager.println("DownloadManager startup");
                }
                MUTEX_PREFIX = "jkernel";
                boolean bl = !"false".equals(System.getProperty(DownloadManager.KERNEL_DOWNLOAD_ENABLED_PROPERTY));
                boolean bl2 = complete = !DownloadManager.getBundlePath().exists() || !bl;
                if (!complete) {
                    DownloadManager.loadJKernelLibrary();
                    DownloadManager.log("Log opened");
                    if (DownloadManager.isWindowsVista()) {
                        DownloadManager.getLocalLowTempBundlePath().mkdirs();
                    }
                    new Thread(){

                        @Override
                        public void run() {
                            DownloadManager.startBackgroundDownloads();
                        }
                    }.start();
                    try {
                        String string = DownloadManager.isWindowsVista() ? USER_HOME + "\\appdata\\locallow\\dummy.kernel" : USER_HOME + "\\dummy.kernel";
                        File file = new File(string);
                        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                        fileOutputStream.close();
                        file.deleteOnExit();
                    }
                    catch (IOException iOException) {
                        DownloadManager.log(iOException);
                    }
                    new Thread("BundleDownloader"){

                        @Override
                        public void run() {
                            DownloadManager.downloadRequestedBundles();
                        }
                    }.start();
                }
                return null;
            }
        });
    }

    private static class StreamMonitor
    implements Runnable {
        private InputStream istream;

        public StreamMonitor(InputStream inputStream) {
            this.istream = new BufferedInputStream(inputStream);
            new Thread(this).start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n = this.istream.read(byArray);
                while (n != -1) {
                    n = this.istream.read(byArray);
                }
            }
            catch (IOException iOException) {
                try {
                    this.istream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }
}

