/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CommonUI {
    public static final int BUTTON_WIDTH = 100;
    public static final int BUTTON_HEIGHT = 26;
    public static final int BUTTCON_WIDTH = 28;
    public static final int BUTTCON_HEIGHT = 28;
    public static final int SM_BUTTON_WIDTH = 72;
    public static final int SM_BUTTON_HEIGHT = 26;
    public static final int LABEL_WIDTH = 100;
    public static final int LABEL_HEIGHT = 20;
    public static final int TEXT_WIDTH = 150;
    public static final int TEXT_HEIGHT = 20;
    public static Dimension buttonPrefSize = new Dimension(100, 26);
    public static Dimension buttconPrefSize = new Dimension(28, 28);
    public static Dimension smbuttonPrefSize = new Dimension(72, 26);
    public static Dimension labelPrefSize = new Dimension(100, 20);
    public static Dimension textPrefSize = new Dimension(150, 20);

    public static JLabel createLabel(String text, int mnemonic, Component comp) {
        JLabel label = new JLabel("  " + text);
        label.setMinimumSize(labelPrefSize);
        if (mnemonic != -1) {
            label.setDisplayedMnemonic(mnemonic);
        }
        if (comp != null) {
            label.setLabelFor(comp);
        }
        if (text.length() == 0) {
            label.setPreferredSize(labelPrefSize);
        }
        return label;
    }

    public static JLabel createLabel(String text) {
        return CommonUI.createLabel(text, -1, null);
    }

    public static JTextField createTextField(String text, KeyListener listener, boolean numbers) {
        JTextField field = new JTextField(text);
        field.setMinimumSize(textPrefSize);
        if (text.length() == 0) {
            field.setPreferredSize(textPrefSize);
        }
        if (listener != null) {
            field.addKeyListener(listener);
        }
        if (numbers) {
            field.setDocument(new NumberDocument());
        }
        return field;
    }

    public static JTextField createTextField(String text, boolean numbers) {
        return CommonUI.createTextField(text, null, numbers);
    }

    public static JTextField createTextField(String text, KeyListener listener) {
        return CommonUI.createTextField(text, listener, false);
    }

    public static JTextField createTextField(String text) {
        return CommonUI.createTextField(text, null, false);
    }

    public static JRadioButton createRadioButton(String text, int mnemonic, ActionListener listener, boolean selected) {
        JRadioButton button = new JRadioButton(text);
        button.setMnemonic(mnemonic);
        button.setSelected(selected);
        button.setMinimumSize(labelPrefSize);
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (text.length() == 0) {
            button.setPreferredSize(labelPrefSize);
        }
        return button;
    }

    public static JRadioButton createRadioButton(String text, int mnemonic, boolean selected) {
        return CommonUI.createRadioButton(text, mnemonic, null, selected);
    }

    public static JRadioButton createRadioButton(String text, int mnemonic, ActionListener listener) {
        return CommonUI.createRadioButton(text, mnemonic, listener, false);
    }

    public static JRadioButton createRadioButton(String text, int mnemonic) {
        return CommonUI.createRadioButton(text, mnemonic, null, false);
    }

    public static JRadioButton createRadioButton(String text) {
        return CommonUI.createRadioButton(text, -1, null, false);
    }

    public static JCheckBox createCheckBox(String text, int mnemonic, ActionListener listener, boolean selected) {
        JCheckBox checkbox = new JCheckBox(text);
        checkbox.setMinimumSize(labelPrefSize);
        if (mnemonic != -1) {
            checkbox.setMnemonic(mnemonic);
        }
        checkbox.setSelected(selected);
        if (text.length() == 0) {
            checkbox.setPreferredSize(labelPrefSize);
        }
        if (listener != null) {
            checkbox.addActionListener(listener);
        }
        return checkbox;
    }

    public static JCheckBox createCheckBox(String text, int mnemonic, ActionListener listener) {
        return CommonUI.createCheckBox(text, mnemonic, listener, false);
    }

    public static JCheckBox createCheckBox(String text, int mnemonic, boolean selected) {
        return CommonUI.createCheckBox(text, mnemonic, null, selected);
    }

    public static JCheckBox createCheckBox(String text, int mnemonic) {
        return CommonUI.createCheckBox(text, mnemonic, null, false);
    }

    public static JCheckBox createCheckBox(String text) {
        return CommonUI.createCheckBox(text, -1, null, false);
    }

    public static JComboBox createComboBox(Object[] items, ActionListener listener, boolean editable) {
        JComboBox<Object> comboBox = new JComboBox<Object>(items);
        if (listener != null) {
            comboBox.addActionListener(listener);
        }
        comboBox.setEditable(editable);
        return comboBox;
    }

    public static JComboBox createComboBox(Object[] items, boolean editable) {
        return CommonUI.createComboBox(items, null, editable);
    }

    public static JComboBox createComboBox(Vector items, ActionListener listener, boolean editable) {
        JComboBox comboBox = new JComboBox(items);
        if (listener != null) {
            comboBox.addActionListener(listener);
        }
        comboBox.setEditable(editable);
        return comboBox;
    }

    public static JComboBox createComboBox(Vector items, boolean editable) {
        return CommonUI.createComboBox(items, null, editable);
    }

    public static JButton createButton(Action action) {
        JButton button = new JButton(action);
        CommonUI.setButtonSize(button, buttonPrefSize);
        return button;
    }

    public static JButton createButton(String text, ActionListener listener, int mnemonic) {
        JButton button = new JButton(text);
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (mnemonic != -1) {
            button.setMnemonic(mnemonic);
        }
        CommonUI.setButtonSize(button, buttonPrefSize);
        return button;
    }

    private static void setButtonSize(JButton button, Dimension size) {
        String text = button.getText();
        button.setMinimumSize(size);
        if (text.length() == 0) {
            button.setPreferredSize(size);
        } else {
            Dimension psize = button.getPreferredSize();
            if (psize.width < size.width) {
                button.setPreferredSize(size);
            }
        }
    }

    public static JButton createButton(String text, ActionListener listener) {
        return CommonUI.createButton(text, listener, -1);
    }

    public static JButton createSmallButton(String text, ActionListener listener, int mnemonic) {
        JButton button = CommonUI.createButton(text, listener, mnemonic);
        CommonUI.setButtonSize(button, smbuttonPrefSize);
        return button;
    }

    public static JButton createSmallButton(String text, ActionListener listener) {
        return CommonUI.createSmallButton(text, listener, -1);
    }

    public static Border createBorder(String text) {
        Border border = BorderFactory.createEtchedBorder();
        return BorderFactory.createTitledBorder(border, text, 0, 2);
    }

    public static Border createBorder() {
        return BorderFactory.createEmptyBorder(4, 4, 4, 4);
    }

    public static JScrollPane createListPane(JList list, String text) {
        JScrollPane pane = new JScrollPane(list);
        pane.setBorder(BorderFactory.createCompoundBorder(CommonUI.createBorder(text), BorderFactory.createLoweredBevelBorder()));
        return pane;
    }

    public static void centerComponent(Component source, Component parent) {
        Rectangle rect;
        Dimension dim = source.getSize();
        if (parent != null) {
            rect = parent.getBounds();
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            rect = new Rectangle(0, 0, d.width, d.height);
        }
        int x = rect.x + (rect.width - dim.width) / 2;
        int y = rect.y + (rect.height - dim.height) / 2;
        source.setLocation(x, y);
    }

    public static void centerComponent(Component source) {
        CommonUI.centerComponent(source, null);
    }

    public static JFrame getParentFrame(Component source) {
        Container parent;
        for (parent = source.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (JFrame)parent;
    }

    public static Integer msToSec(Integer ms) {
        int value = ms;
        return new Integer(value /= 1000);
    }

    public static Integer secToMs(Integer sec) {
        int value = sec;
        return new Integer(value *= 1000);
    }

    public static String stringFromStringArray(String[] strings, String delim) {
        String string = "";
        String separator = delim == null || delim.equals("") ? " " : delim;
        for (int i = 0; i < strings.length; ++i) {
            string = string + strings[i];
            string = string + separator;
        }
        return string;
    }

    public static String stringFromStringArray(String[] strings) {
        return CommonUI.stringFromStringArray(strings, "");
    }

    public static String[] stringArrayFromString(String string, String delim) {
        StringTokenizer st = delim == null || delim.equals("") ? new StringTokenizer(string) : new StringTokenizer(string, delim);
        int numTokens = st.countTokens();
        String[] strings = new String[numTokens];
        int index = 0;
        while (st.hasMoreTokens()) {
            strings[index++] = st.nextToken();
        }
        return strings;
    }

    public static String[] stringArrayFromString(String string) {
        return CommonUI.stringArrayFromString(string, "");
    }

    public static void setWaitCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursor(Component comp) {
        comp.setCursor(Cursor.getPredefinedCursor(0));
    }

    private static class NumberDocument
    extends PlainDocument {
        public void insertString(int offs, String str, AttributeSet atts) throws BadLocationException {
            if (!Character.isDigit(str.charAt(0))) {
                return;
            }
            super.insertString(offs, str, atts);
        }

        private NumberDocument() {
        }
    }
}

