/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineWayAction
extends JosmAction {
    public CombineWayAction() {
        super(I18n.tr("Combine Way"), "combineway", I18n.tr("Combine several ways into one."), Shortcut.registerShortcut("tools:combineway", I18n.tr("Tool: {0}", I18n.tr("Combine Way")), 67, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/CombineWay"));
    }

    protected boolean confirmChangeDirectionOfWays() {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Change directions?"), new String[]{I18n.tr("Reverse and Combine"), I18n.tr("Cancel")});
        ed.setButtonIcons(new String[]{"wayflip.png", "cancel.png"});
        ed.setContent(I18n.tr("The ways can not be combined in their current directions.  Do you want to reverse some of them?"));
        ed.showDialog();
        return ed.getValue() == 1;
    }

    protected void warnCombiningImpossible() {
        String msg = I18n.tr("Could not combine ways (They could not be merged into a single string of nodes)");
        JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Information"), 1);
    }

    protected Way getTargetWay(Collection<Way> combinedWays) {
        Way targetWay = combinedWays.iterator().next();
        Iterator<Way> i$ = combinedWays.iterator();
        while (i$.hasNext()) {
            Way w;
            targetWay = w = i$.next();
            if (w.isNew()) continue;
            break;
        }
        return targetWay;
    }

    protected Set<Relation> getParentRelations(Collection<Way> ways) {
        HashSet<Relation> ret = new HashSet<Relation>();
        for (Way w : ways) {
            ret.addAll(OsmPrimitive.getFilteredList(w.getReferrers(), Relation.class));
        }
        return ret;
    }

    public Way combineWays(Collection<Way> ways) {
        if (ways == null || ways.isEmpty()) {
            return null;
        }
        ways.remove(null);
        ways = new HashSet<Way>(ways);
        NodeGraph graph = NodeGraph.createUndirectedGraphFromNodeWays(ways);
        List<Node> path = graph.buildSpanningPath();
        if (path == null) {
            this.warnCombiningImpossible();
            return null;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        List<Way> reversedWays = new LinkedList<Way>();
        List<Way> unreversedWays = new LinkedList<Way>();
        for (Way w : ways) {
            if (path.indexOf(w.getNode(0)) + 1 == path.lastIndexOf(w.getNode(1))) {
                unreversedWays.add(w);
                continue;
            }
            reversedWays.add(w);
        }
        if (unreversedWays.isEmpty()) {
            Collections.reverse(path);
            unreversedWays = reversedWays;
            reversedWays = null;
        }
        if (reversedWays != null && !reversedWays.isEmpty()) {
            if (!this.confirmChangeDirectionOfWays()) {
                return null;
            }
            unreversedWays = ReverseWayTagCorrector.irreversibleWays(unreversedWays);
            if ((reversedWays = ReverseWayTagCorrector.irreversibleWays(reversedWays)).size() > unreversedWays.size()) {
                Collections.reverse(path);
                List<Way> tempWays = unreversedWays;
                unreversedWays = reversedWays;
                reversedWays = tempWays;
            }
            if (!reversedWays.isEmpty() && Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                ArrayList<Way> unreversedTagWays = new ArrayList<Way>(ways);
                unreversedTagWays.removeAll(reversedWays);
                ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
                ArrayList<Way> reversedTagWays = new ArrayList<Way>();
                Collection<Command> changePropertyCommands = null;
                for (Way w : reversedWays) {
                    Way wnew = new Way(w);
                    reversedTagWays.add(wnew);
                    try {
                        changePropertyCommands = reverseWayTagCorrector.execute(w, wnew);
                    }
                    catch (UserCancelException ex) {
                        return null;
                    }
                }
                if (changePropertyCommands != null && !changePropertyCommands.isEmpty()) {
                    for (Command c : changePropertyCommands) {
                        c.executeCommand();
                    }
                }
                wayTags = TagCollection.unionOfAllPrimitives(reversedTagWays);
                wayTags.add(TagCollection.unionOfAllPrimitives(unreversedTagWays));
            }
        }
        Way targetWay = this.getTargetWay(ways);
        Way modifiedTargetWay = new Way(targetWay);
        modifiedTargetWay.setNodes(path);
        TagCollection completeWayTags = new TagCollection(wayTags);
        TagConflictResolutionUtil.combineTigerTags(completeWayTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(completeWayTags, ways);
        TagCollection tagsToEdit = new TagCollection(completeWayTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, completeWayTags.getKeysWithMultipleValues());
        dialog.setTargetPrimitive(targetWay);
        Set<Relation> parentRelations = this.getParentRelations(ways);
        dialog.getRelationMemberConflictResolverModel().populate(parentRelations, ways);
        dialog.prepareDefaultDecisions();
        if (!completeWayTags.isApplicableToPrimitive() || !parentRelations.isEmpty()) {
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return null;
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        LinkedList<Way> deletedWays = new LinkedList<Way>(ways);
        deletedWays.remove(targetWay);
        cmds.add(new ChangeCommand(targetWay, modifiedTargetWay));
        cmds.addAll(dialog.buildResolutionCommands());
        cmds.add(new DeleteCommand(deletedWays));
        SequenceCommand sequenceCommand = new SequenceCommand(I18n.tr("Combine {0} ways", ways.size()), cmds);
        Main.main.undoRedo.add(sequenceCommand);
        return targetWay;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        LinkedHashSet<Way> selectedWays = OsmPrimitive.getFilteredSet(selection, Way.class);
        if (selectedWays.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two ways to combine."), I18n.tr("Information"), 1);
            return;
        }
        final Way selectedWay = this.combineWays(selectedWays);
        if (selectedWay != null) {
            Runnable guiTask = new Runnable(){

                public void run() {
                    CombineWayAction.this.getCurrentDataSet().setSelected(selectedWay);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                guiTask.run();
            } else {
                SwingUtilities.invokeLater(guiTask);
            }
        }
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        this.updateEnabledState(selection);
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        int numWays = 0;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++numWays;
        }
        this.setEnabled(numWays >= 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeGraph {
        private Set<NodePair> edges = new HashSet<NodePair>();
        private int numUndirectedEges = 0;
        private HashMap<Node, List<NodePair>> successors;
        private HashMap<Node, List<NodePair>> predecessors;

        public static List<NodePair> buildNodePairs(Way way, boolean directed) {
            ArrayList<NodePair> pairs = new ArrayList<NodePair>();
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                pairs.add(new NodePair(pair));
                if (directed) continue;
                pairs.add(new NodePair(pair).swap());
            }
            return pairs;
        }

        public static List<NodePair> buildNodePairs(List<Way> ways, boolean directed) {
            ArrayList<NodePair> pairs = new ArrayList<NodePair>();
            for (Way w : ways) {
                pairs.addAll(NodeGraph.buildNodePairs(w, directed));
            }
            return pairs;
        }

        public static List<NodePair> eliminateDuplicateNodePairs(List<NodePair> pairs) {
            ArrayList<NodePair> cleaned = new ArrayList<NodePair>();
            for (NodePair p : pairs) {
                if (cleaned.contains(p) || cleaned.contains(p.swap())) continue;
                cleaned.add(p);
            }
            return cleaned;
        }

        public static NodeGraph createDirectedGraphFromNodePairs(List<NodePair> pairs) {
            NodeGraph graph = new NodeGraph();
            for (NodePair pair : pairs) {
                graph.add(pair);
            }
            return graph;
        }

        public static NodeGraph createDirectedGraphFromWays(Collection<Way> ways) {
            NodeGraph graph = new NodeGraph();
            for (Way w : ways) {
                graph.add(NodeGraph.buildNodePairs(w, true));
            }
            return graph;
        }

        public static NodeGraph createUndirectedGraphFromNodeList(List<NodePair> pairs) {
            NodeGraph graph = new NodeGraph();
            for (NodePair pair : pairs) {
                graph.add(pair);
                graph.add(pair.swap());
            }
            return graph;
        }

        public static NodeGraph createUndirectedGraphFromNodeWays(Collection<Way> ways) {
            NodeGraph graph = new NodeGraph();
            for (Way w : ways) {
                graph.add(NodeGraph.buildNodePairs(w, false));
            }
            return graph;
        }

        protected void rememberSuccessor(NodePair pair) {
            if (this.successors.containsKey(pair.getA())) {
                if (!this.successors.get(pair.getA()).contains(pair)) {
                    this.successors.get(pair.getA()).add(pair);
                }
            } else {
                ArrayList<NodePair> l = new ArrayList<NodePair>();
                l.add(pair);
                this.successors.put(pair.getA(), l);
            }
        }

        protected void rememberPredecessors(NodePair pair) {
            if (this.predecessors.containsKey(pair.getB())) {
                if (!this.predecessors.get(pair.getB()).contains(pair)) {
                    this.predecessors.get(pair.getB()).add(pair);
                }
            } else {
                ArrayList<NodePair> l = new ArrayList<NodePair>();
                l.add(pair);
                this.predecessors.put(pair.getB(), l);
            }
        }

        protected boolean isTerminalNode(Node n) {
            if (this.successors.get(n) == null) {
                return false;
            }
            if (this.successors.get(n).size() != 1) {
                return false;
            }
            if (this.predecessors.get(n) == null) {
                return true;
            }
            if (this.predecessors.get(n).size() == 1) {
                NodePair p1 = this.successors.get(n).iterator().next();
                NodePair p2 = this.predecessors.get(n).iterator().next();
                return p1.equals(p2.swap());
            }
            return false;
        }

        protected void prepare() {
            HashSet<NodePair> undirectedEdges = new HashSet<NodePair>();
            this.successors = new HashMap();
            this.predecessors = new HashMap();
            for (NodePair pair : this.edges) {
                if (!undirectedEdges.contains(pair) && !undirectedEdges.contains(pair.swap())) {
                    undirectedEdges.add(pair);
                }
                this.rememberSuccessor(pair);
                this.rememberPredecessors(pair);
            }
            this.numUndirectedEges = undirectedEdges.size();
        }

        public void add(NodePair pair) {
            if (!this.edges.contains(pair)) {
                this.edges.add(pair);
            }
        }

        public void add(List<NodePair> pairs) {
            for (NodePair pair : pairs) {
                this.add(pair);
            }
        }

        protected Node getStartNode() {
            Set<Node> nodes = this.getNodes();
            for (Node n : nodes) {
                if (this.successors.get(n) == null || this.successors.get(n).size() != 1) continue;
                return n;
            }
            return null;
        }

        protected Set<Node> getTerminalNodes() {
            HashSet<Node> ret = new HashSet<Node>();
            for (Node n : this.getNodes()) {
                if (!this.isTerminalNode(n)) continue;
                ret.add(n);
            }
            return ret;
        }

        protected Set<Node> getNodes(Stack<NodePair> pairs) {
            HashSet<Node> nodes = new HashSet<Node>();
            for (NodePair pair : pairs) {
                nodes.add(pair.getA());
                nodes.add(pair.getB());
            }
            return nodes;
        }

        protected List<NodePair> getOutboundPairs(NodePair pair) {
            return this.getOutboundPairs(pair.getB());
        }

        protected List<NodePair> getOutboundPairs(Node node) {
            List<NodePair> l = this.successors.get(node);
            if (l == null) {
                return Collections.emptyList();
            }
            return l;
        }

        protected Set<Node> getNodes() {
            HashSet<Node> nodes = new HashSet<Node>();
            for (NodePair pair : this.edges) {
                nodes.add(pair.getA());
                nodes.add(pair.getB());
            }
            return nodes;
        }

        protected boolean isSpanningWay(Stack<NodePair> way) {
            return this.numUndirectedEges == way.size();
        }

        protected List<Node> buildPathFromNodePairs(Stack<NodePair> path) {
            LinkedList<Node> ret = new LinkedList<Node>();
            for (NodePair pair : path) {
                ret.add(pair.getA());
            }
            ret.add(path.peek().getB());
            return ret;
        }

        protected List<Node> buildSpanningPath(Node startNode) {
            if (startNode == null) {
                return null;
            }
            Stack<NodePair> path = new Stack<NodePair>();
            Stack<NodePair> nextPairs = new Stack<NodePair>();
            nextPairs.addAll(this.getOutboundPairs(startNode));
            while (!nextPairs.isEmpty()) {
                NodePair cur = (NodePair)nextPairs.pop();
                if (path.contains(cur) || path.contains(cur.swap())) continue;
                while (!path.isEmpty() && !((NodePair)path.peek()).isPredecessorOf(cur)) {
                    path.pop();
                }
                path.push(cur);
                if (this.isSpanningWay(path)) {
                    return this.buildPathFromNodePairs(path);
                }
                nextPairs.addAll(this.getOutboundPairs(path.peek()));
            }
            return null;
        }

        public List<Node> buildSpanningPath() {
            this.prepare();
            Set<Node> nodes = this.getTerminalNodes();
            nodes = nodes.isEmpty() ? this.getNodes() : nodes;
            for (Node n : nodes) {
                List<Node> path = this.buildSpanningPath(n);
                if (path == null) continue;
                return path;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodePair {
        private Node a;
        private Node b;

        public NodePair(Node a, Node b) {
            this.a = a;
            this.b = b;
        }

        public NodePair(Pair<Node, Node> pair) {
            this.a = (Node)pair.a;
            this.b = (Node)pair.b;
        }

        public NodePair(NodePair other) {
            this.a = other.a;
            this.b = other.b;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public boolean isAdjacentToA(NodePair other) {
            return other.getA() == this.a || other.getB() == this.a;
        }

        public boolean isAdjacentToB(NodePair other) {
            return other.getA() == this.b || other.getB() == this.b;
        }

        public boolean isSuccessorOf(NodePair other) {
            return other.getB() == this.a;
        }

        public boolean isPredecessorOf(NodePair other) {
            return this.b == other.getA();
        }

        public NodePair swap() {
            return new NodePair(this.b, this.a);
        }

        public String toString() {
            return "[" + this.a.getId() + "," + this.b.getId() + "]";
        }

        public boolean contains(Node n) {
            return this.a == n || this.b == n;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePair other = (NodePair)obj;
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            return !(this.b == null ? other.b != null : !this.b.equals(other.b));
        }
    }
}

