/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopyAction
extends JosmAction {
    private LinkedList<JosmAction> listeners;

    public CopyAction() {
        super(I18n.tr("Copy"), "copy", I18n.tr("Copy selected objects to paste buffer."), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy")), 67, 2), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
        this.listeners = new LinkedList();
    }

    @Override
    public void addListener(JosmAction a) {
        this.listeners.add(a);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        StringBuilder idsBuilder = new StringBuilder();
        for (OsmPrimitive p : selection) {
            idsBuilder.append(p.getId() + ",");
        }
        String ids = idsBuilder.substring(0, idsBuilder.length() - 1);
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ids.toString()), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
        catch (RuntimeException x) {
            // empty catch block
        }
        Main.pasteBuffer.makeCopy(selection);
        Main.pasteSource = this.getEditLayer();
        Main.main.menu.paste.setEnabled(true);
        for (JosmAction a : this.listeners) {
            a.pasteBufferChanged(Main.pasteBuffer);
        }
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy."), I18n.tr("Information"), 1);
            return true;
        }
        return false;
    }
}

