/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinAreasAction
extends JosmAction {
    private LinkedList<Command> cmds = new LinkedList();
    private int cmdsCount = 0;

    public JoinAreasAction() {
        super(I18n.tr("Join overlapping Areas"), "joinareas", I18n.tr("Joins areas that overlap each other"), Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tool: {0}", I18n.tr("Join overlapping Areas")), 74, 3, 1), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LinkedList<Way> ways = new LinkedList<Way>(Main.main.getCurrentDataSet().getSelectedWays());
        if (ways.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one closed way that should be joined."));
            return;
        }
        if (ways.size() > 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Only up to two areas can be joined at the moment."));
            return;
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way way : ways) {
            if (!way.isClosed()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("\"{0}\" is not closed and therefore cannot be joined.", way.getName()));
                return;
            }
            allNodes.addAll(way.getNodes());
        }
        Area dataSourceArea = Main.main.getCurrentDataSet().getDataSourceArea();
        if (dataSourceArea != null) {
            for (Node node : allNodes) {
                if (dataSourceArea.contains(node.getCoor())) continue;
                int option = JOptionPane.showConfirmDialog(Main.parent, I18n.trn("The selected way has nodes outside of the downloaded data region.", "The selected ways have nodes outside of the downloaded data region.", ways.size()) + "\n" + I18n.tr("This can lead to nodes being deleted accidentally.") + "\n" + I18n.tr("Are you really sure to continue?"), I18n.tr("Please abort if you are not sure"), 0, 2);
                if (option == 0) break;
                return;
            }
        }
        if (this.joinAreas(ways.getFirst(), ways.getLast())) {
            Main.map.mapView.repaint();
            DataSet ds = Main.main.getCurrentDataSet();
            ds.fireSelectionChanged();
        } else {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No intersection found. Nothing was changed."));
        }
    }

    private boolean joinAreas(Way a, Way b) {
        ArrayList<OsmPrimitive> nodes;
        boolean same = a.equals(b);
        boolean hadChanges = false;
        if (!same) {
            int i = 0;
            if (this.checkForTagConflicts(a, b)) {
                return true;
            }
            if (this.joinAreas(a, a)) {
                ++i;
            }
            if (this.joinAreas(b, b)) {
                ++i;
            }
            hadChanges = i > 0;
            this.cmdsCount = i;
        }
        if ((nodes = this.addIntersections(a, b)).size() == 0) {
            return hadChanges;
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> relations = this.removeFromRelations(a);
        if (!same) {
            relations.addAll(this.removeFromRelations(b));
        }
        boolean warnAboutRelations = relations.size() > 0;
        Collection<Way> allWays = this.splitWaysOnNodes(a, b, nodes);
        Collection<Node> allNodes = this.getNodesFromWays(allWays);
        Collection<Way> innerWays = this.findInnerWays(allWays, allNodes);
        Way outerWay = this.joinOuterWays(allWays, innerWays);
        ArrayList<Way> newInnerWays = this.fixMultipolygons(innerWays, outerWay, same);
        if (innerWays != null && innerWays.size() > 0) {
            this.cmds.add(DeleteCommand.delete(Main.map.mapView.getEditLayer(), innerWays, true));
        }
        this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        this.addOwnMultigonRelation(newInnerWays, outerWay, relations);
        this.fixRelations(relations, outerWay);
        this.commitCommands(I18n.marktr("Fix relations"));
        this.stripTags(newInnerWays);
        this.makeCommitsOneAction(same ? I18n.marktr("Joined self-overlapping area") : I18n.marktr("Joined overlapping areas"));
        if (warnAboutRelations) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some of the ways were part of relations that have been modified. Please verify no errors have been introduced."));
        }
        return true;
    }

    private boolean checkForTagConflicts(Way a, Way b) {
        ArrayList<Way> ways = new ArrayList<Way>();
        ways.add(a);
        ways.add(b);
        TreeMap props = new TreeMap();
        for (Way w : ways) {
            for (String key : w.keySet()) {
                if (!props.containsKey(key)) {
                    props.put(key, new TreeSet());
                }
                ((Set)props.get(key)).add(w.get(key));
            }
        }
        Way ax = new Way(a);
        Way bx = new Way(b);
        HashMap components = new HashMap();
        JPanel p = new JPanel(new GridBagLayout());
        for (Map.Entry e : props.entrySet()) {
            if (TigerUtils.isTigerTag((String)e.getKey())) {
                String combined = TigerUtils.combineTags((String)e.getKey(), (Set)e.getValue());
                ax.put((String)e.getKey(), combined);
                bx.put((String)e.getKey(), combined);
                continue;
            }
            if (((Set)e.getValue()).size() > 1) {
                if ("created_by".equals(e.getKey())) {
                    ax.remove("created_by");
                    bx.remove("created_by");
                    continue;
                }
                JComboBox<Object> c = new JComboBox<Object>(((Set)e.getValue()).toArray());
                c.setEditable(true);
                p.add((Component)new JLabel((String)e.getKey()), GBC.std());
                p.add(Box.createHorizontalStrut(10), GBC.std());
                p.add(c, GBC.eol());
                components.put(e.getKey(), c);
                continue;
            }
            String val = (String)((Set)e.getValue()).iterator().next();
            ax.put((String)e.getKey(), val);
            bx.put((String)e.getKey(), val);
        }
        if (components.isEmpty()) {
            return false;
        }
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Enter values for all conflicts."), new String[]{I18n.tr("Solve Conflicts"), I18n.tr("Cancel")});
        ed.setButtonIcons(new String[]{"dialogs/conflict.png", "cancel.png"});
        ed.setContent(p);
        ed.showDialog();
        if (ed.getValue() != 1) {
            return true;
        }
        for (Map.Entry e : components.entrySet()) {
            String val = ((JComboBox)e.getValue()).getEditor().getItem().toString();
            ax.put((String)e.getKey(), val);
            bx.put((String)e.getKey(), val);
        }
        this.cmds.add(new ChangeCommand(a, ax));
        this.cmds.add(new ChangeCommand(b, bx));
        this.commitCommands(I18n.marktr("Fix tag conflicts"));
        return false;
    }

    private ArrayList<OsmPrimitive> addIntersections(Way a, Way b) {
        int i;
        boolean same = a.equals(b);
        int nodesSizeA = a.getNodesCount();
        int nodesSizeB = b.getNodesCount();
        ArrayList<OsmPrimitive> nodes = new ArrayList<OsmPrimitive>();
        ArrayList<NodeToSegs> nodesA = new ArrayList<NodeToSegs>();
        ArrayList<NodeToSegs> nodesB = new ArrayList<NodeToSegs>();
        int n = i = same ? 1 : 0;
        while (i < nodesSizeA - 1) {
            int j;
            int n2 = j = same ? i + 2 : 0;
            while (j < nodesSizeB - 1) {
                if (a.getNode(i).equals(b.getNode(j)) || a.getNode(i + 1).equals(b.getNode(j))) {
                    nodes.add(b.getNode(j));
                } else if (a.getNode(i).equals(b.getNode(j + 1)) || a.getNode(i + 1).equals(b.getNode(j + 1))) {
                    nodes.add(b.getNode(j + 1));
                } else {
                    LatLon intersection = JoinAreasAction.getLineLineIntersection(a.getNode(i).getEastNorth().east(), a.getNode(i).getEastNorth().north(), a.getNode(i + 1).getEastNorth().east(), a.getNode(i + 1).getEastNorth().north(), b.getNode(j).getEastNorth().east(), b.getNode(j).getEastNorth().north(), b.getNode(j + 1).getEastNorth().east(), b.getNode(j + 1).getEastNorth().north());
                    if (intersection != null) {
                        Node n3 = new Node(intersection);
                        this.cmds.add(new AddCommand(n3));
                        nodes.add(n3);
                        nodesA.add(new NodeToSegs(i, n3, a.getNode(i).getCoor()));
                        if (same) {
                            nodesA.add(new NodeToSegs(j, n3, a.getNode(j).getCoor()));
                        } else {
                            nodesB.add(new NodeToSegs(j, n3, b.getNode(j).getCoor()));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.addNodesToWay(a, nodesA);
        if (!same) {
            this.addNodesToWay(b, nodesB);
        }
        return nodes;
    }

    private static LatLon getLineLineIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a1 = y2 - y1;
        double b1 = x1 - x2;
        double c1 = x2 * y1 - x1 * y2;
        double a2 = y4 - y3;
        double b2 = x3 - x4;
        double c2 = x4 * y3 - x3 * y4;
        double det = a1 * b2 - a2 * b1;
        if (det == 0.0) {
            return null;
        }
        return Main.proj.eastNorth2latlon(new EastNorth((b1 * c2 - b2 * c1) / det, (a2 * c1 - a1 * c2) / det));
    }

    private void addNodesToWay(Way a, ArrayList<NodeToSegs> nodes) {
        if (nodes.size() == 0) {
            return;
        }
        Way ax = new Way(a);
        Collections.sort(nodes);
        int numOfAdds = 1;
        for (NodeToSegs n : nodes) {
            ax.addNode(n.pos + numOfAdds, n.n);
            ++numOfAdds;
        }
        this.cmds.add(new ChangeCommand(a, ax));
    }

    private void commitCommands(String description) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                Main.main.undoRedo.add(this.cmds.getFirst());
                break;
            }
            default: {
                SequenceCommand c = new SequenceCommand(I18n.tr(description), this.cmds);
                Main.main.undoRedo.add(c);
            }
        }
        this.cmds.clear();
        ++this.cmdsCount;
    }

    private ArrayList<RelationRole> removeFromRelations(OsmPrimitive osm) {
        ArrayList<RelationRole> result = new ArrayList<RelationRole>();
        block0: for (Relation r : Main.main.getCurrentDataSet().getRelations()) {
            if (r.isDeleted()) continue;
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember() != osm) continue;
                Relation newRel = new Relation(r);
                List<RelationMember> members = newRel.getMembers();
                members.remove(rm);
                newRel.setMembers(members);
                this.cmds.add(new ChangeCommand(r, newRel));
                RelationRole saverel = new RelationRole(r, rm.getRole());
                if (result.contains(saverel)) continue block0;
                result.add(saverel);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return result;
    }

    private Collection<Way> splitWaysOnNodes(Way a, Way b, Collection<OsmPrimitive> nodes) {
        ArrayList<Way> ways = new ArrayList<Way>();
        ways.add(a);
        if (!a.equals(b)) {
            ways.add(b);
        }
        ArrayList<OsmPrimitive> affected = new ArrayList<OsmPrimitive>();
        for (Way way : ways) {
            nodes.add(way);
            Main.main.getCurrentDataSet().setSelected(nodes);
            nodes.remove(way);
            new SplitWayAction().actionPerformed(null);
            ++this.cmdsCount;
            affected.addAll(Main.main.getCurrentDataSet().getSelectedWays());
        }
        return JoinAreasAction.osmprim2way(affected);
    }

    private static Collection<Way> osmprim2way(Collection<OsmPrimitive> ways) {
        ArrayList<Way> result = new ArrayList<Way>();
        for (OsmPrimitive w : ways) {
            if (!(w instanceof Way)) continue;
            result.add((Way)w);
        }
        return result;
    }

    private Collection<Node> getNodesFromWays(Collection<Way> ways) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way w : ways) {
            allNodes.addAll(w.getNodes());
        }
        return allNodes;
    }

    private Collection<Way> findInnerWays(Collection<Way> multigonWays, Collection<Node> multigonNodes) {
        ArrayList<Way> innerWays = new ArrayList<Way>();
        for (Way w : multigonWays) {
            Polygon poly = new Polygon();
            for (Node n : w.getNodes()) {
                poly.addPoint(this.latlonToXY(n.getCoor().lat()), this.latlonToXY(n.getCoor().lon()));
            }
            for (Node n : multigonNodes) {
                if (w.containsNode(n) || !poly.contains(this.latlonToXY(n.getCoor().lat()), this.latlonToXY(n.getCoor().lon()))) continue;
                this.getWaysByNode(innerWays, multigonWays, n);
            }
        }
        return innerWays;
    }

    private int latlonToXY(double val) {
        return (int)Math.round(val * 1000000.0);
    }

    private void getWaysByNode(Collection<Way> innerWays, Collection<Way> w, Node n) {
        for (Way way : w) {
            if (!way.containsNode(n) || innerWays.contains(way)) continue;
            innerWays.add(way);
        }
    }

    private Way joinOuterWays(Collection<Way> multigonWays, Collection<Way> innerWays) {
        ArrayList<Way> join = new ArrayList<Way>();
        for (Way w : multigonWays) {
            if (innerWays.contains(w)) continue;
            if (w.getNodesCount() <= 2) {
                this.cmds.add(new DeleteCommand(w));
                continue;
            }
            join.add(w);
        }
        this.commitCommands(I18n.marktr("Join Areas: Remove Short Ways"));
        return this.closeWay(this.joinWays(join));
    }

    private Way closeWay(Way w) {
        if (w.isClosed()) {
            return w;
        }
        Main.main.getCurrentDataSet().setSelected(w);
        Way wnew = new Way(w);
        wnew.addNode(wnew.firstNode());
        this.cmds.add(new ChangeCommand(w, wnew));
        this.commitCommands(I18n.marktr("Closed Way"));
        return (Way)Main.main.getCurrentDataSet().getSelectedWays().toArray()[0];
    }

    private Way joinWays(ArrayList<Way> ways) {
        if (ways.size() < 2) {
            return ways.get(0);
        }
        Way a = null;
        for (Way b : ways) {
            if (a == null) {
                a = b;
                continue;
            }
            if (a.getNode(0).equals(b.getNode(0)) || a.getNode(a.getNodesCount() - 1).equals(b.getNode(b.getNodesCount() - 1))) {
                Main.main.getCurrentDataSet().setSelected(b);
                new ReverseWayAction().actionPerformed(null);
                ++this.cmdsCount;
            }
            a = b;
        }
        a = new CombineWayAction().combineWays(ways);
        if (a != null) {
            ++this.cmdsCount;
        }
        return a;
    }

    private ArrayList<Way> fixMultipolygons(Collection<Way> uninterestingWays, Way outerWay, boolean selfintersect) {
        Collection<Node> innerNodes = this.getNodesFromWays(uninterestingWays);
        List<Node> outerNodes = outerWay.getNodes();
        ArrayList<Way> newInnerWays = new ArrayList<Way>();
        ArrayList<Way> possibleWays = new ArrayList<Way>();
        block0: for (Way w : uninterestingWays) {
            boolean hasInnerNodes = false;
            for (Node n : w.getNodes()) {
                if (outerNodes.contains(n)) {
                    if (selfintersect) continue;
                    continue block0;
                }
                if (hasInnerNodes || !innerNodes.contains(n)) continue;
                hasInnerNodes = true;
            }
            if (!hasInnerNodes || w.getNodesCount() < 2) continue;
            possibleWays.add(w);
        }
        this.removeAlmostAlikeWays(possibleWays);
        for (int k = 0; k < 2; ++k) {
            Way joined = null;
            block3: do {
                this.removePartlyUnconnectedWays(possibleWays);
                joined = null;
                for (Way w1 : possibleWays) {
                    if (w1.isClosed()) {
                        if (!this.wayIsCollapsed(w1)) {
                            uninterestingWays.remove(w1);
                            newInnerWays.add(w1);
                        }
                        joined = w1;
                        possibleWays.remove(w1);
                        continue block3;
                    }
                    ArrayList<Way> secondary = new ArrayList<Way>();
                    for (Way w2 : possibleWays) {
                        int i = 0;
                        if (w1.equals(w2)) continue;
                        if (w2.isFirstLastNode(w1.firstNode())) {
                            ++i;
                        }
                        if (w2.isFirstLastNode(w1.lastNode())) {
                            ++i;
                        }
                        if (i == 2) {
                            if (secondary.size() > 0) {
                                secondary.clear();
                            }
                            secondary.add(w2);
                            break;
                        }
                        if (i <= 0) continue;
                        secondary.add(w2);
                    }
                    if (!(k == 0 ? secondary.size() == 1 : secondary.size() > 0)) continue;
                    ArrayList<Way> joinThem = new ArrayList<Way>();
                    joinThem.add(w1);
                    joinThem.add((Way)secondary.get(0));
                    joined = this.joinWays(joinThem);
                    if (joined == null) continue;
                    uninterestingWays.removeAll(joinThem);
                    possibleWays.removeAll(joinThem);
                    List<Node> nodes = joined.getNodes();
                    uninterestingWays.add(joined);
                    possibleWays.add(joined);
                    continue block3;
                }
            } while (joined != null);
        }
        return newInnerWays;
    }

    private void removeAlmostAlikeWays(ArrayList<Way> ways) {
        ArrayList<Way> removables = new ArrayList<Way>();
        block0: for (int i = 0; i < ways.size(); ++i) {
            Way a = ways.get(i);
            for (int j = i + 1; j < ways.size(); ++j) {
                Way b = ways.get(j);
                ArrayList<Node> revNodes = new ArrayList<Node>(b.getNodes());
                Collections.reverse(revNodes);
                if (!((Object)a.getNodes()).equals(b.getNodes()) && !((Object)a.getNodes()).equals(revNodes)) continue;
                removables.add(a);
                continue block0;
            }
        }
        ways.removeAll(removables);
    }

    private void removePartlyUnconnectedWays(ArrayList<Way> ways) {
        ArrayList<Way> removables = new ArrayList<Way>();
        for (Way a : ways) {
            if (a.isClosed()) continue;
            boolean connectedStart = false;
            boolean connectedEnd = false;
            for (Way b : ways) {
                if (a.equals(b)) continue;
                if (b.isFirstLastNode(a.firstNode())) {
                    connectedStart = true;
                }
                if (!b.isFirstLastNode(a.lastNode())) continue;
                connectedEnd = true;
            }
            if (connectedStart && connectedEnd) continue;
            removables.add(a);
        }
        ways.removeAll(removables);
    }

    private boolean wayIsCollapsed(Way w) {
        if (w.getNodesCount() <= 3) {
            return true;
        }
        Way x = new Way(w);
        int count = 0;
        for (Node n : w.getNodes()) {
            x.removeNode(n);
            if (x.containsNode(n)) {
                ++count;
            }
            if (count != 2) continue;
            return true;
        }
        return false;
    }

    private void addOwnMultigonRelation(Collection<Way> inner, Way outer, ArrayList<RelationRole> rels) {
        if (inner.size() == 0) {
            return;
        }
        Relation newRel = new Relation();
        newRel.put("type", "multipolygon");
        for (Way w : inner) {
            newRel.addMember(new RelationMember("inner", w));
        }
        this.cmds.add(new AddCommand(newRel));
        rels.add(new RelationRole(newRel, "outer"));
    }

    private void fixRelations(ArrayList<RelationRole> rels, Way outer) {
        ArrayList<RelationRole> multiouters = new ArrayList<RelationRole>();
        for (RelationRole r : rels) {
            if (r.rel.get("type") != null && r.rel.get("type").equalsIgnoreCase("multipolygon") && r.role.equalsIgnoreCase("outer")) {
                multiouters.add(r);
                continue;
            }
            Relation newRel = new Relation(r.rel);
            newRel.addMember(new RelationMember(r.role, outer));
            this.cmds.add(new ChangeCommand(r.rel, newRel));
        }
        Relation newRel = null;
        switch (multiouters.size()) {
            case 0: {
                return;
            }
            case 1: {
                newRel = new Relation(((RelationRole)multiouters.get((int)0)).rel);
                newRel.addMember(new RelationMember(((RelationRole)multiouters.get((int)0)).role, outer));
                this.cmds.add(new ChangeCommand(((RelationRole)multiouters.get((int)0)).rel, newRel));
                return;
            }
        }
        newRel = new Relation();
        for (RelationRole r : multiouters) {
            for (RelationMember rm : r.rel.getMembers()) {
                if (newRel.getMembers().contains(rm)) continue;
                newRel.addMember(rm);
            }
            for (String key : r.rel.keySet()) {
                newRel.put(key, r.rel.get(key));
            }
            this.cmds.add(new DeleteCommand(r.rel));
        }
        newRel.addMember(new RelationMember("outer", outer));
        this.cmds.add(new AddCommand(newRel));
    }

    private void stripTags(Collection<Way> ways) {
        for (Way w : ways) {
            this.stripTags(w);
        }
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    private void stripTags(Way x) {
        if (x.getKeys() == null) {
            return;
        }
        Way y = new Way(x);
        for (String key : x.keySet()) {
            y.remove(key);
        }
        this.cmds.add(new ChangeCommand(x, y));
    }

    private void makeCommitsOneAction(String message) {
        int i;
        UndoRedoHandler ur = Main.main.undoRedo;
        this.cmds.clear();
        for (i = Math.max(ur.commands.size() - this.cmdsCount, 0); i < ur.commands.size(); ++i) {
            this.cmds.add(ur.commands.get(i));
        }
        for (i = 0; i < this.cmds.size(); ++i) {
            ur.undo();
        }
        this.commitCommands(message == null ? I18n.marktr("Join Areas Function") : message);
        this.cmdsCount = 0;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        public RelationRole(Relation rel, String role) {
            this.rel = rel;
            this.role = role;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof RelationRole)) {
                return false;
            }
            RelationRole otherMember = (RelationRole)other;
            return otherMember.role.equals(this.role) && otherMember.rel.equals(this.rel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeToSegs
    implements Comparable<NodeToSegs> {
        public int pos;
        public Node n;
        public double dis;

        public NodeToSegs(int pos, Node n, LatLon dis) {
            this.pos = pos;
            this.n = n;
            this.dis = n.getCoor().greatCircleDistance(dis);
        }

        @Override
        public int compareTo(NodeToSegs o) {
            if (this.pos == o.pos) {
                return this.dis - o.dis > 0.0 ? 1 : -1;
            }
            return this.pos - o.pos;
        }

        public int hashCode() {
            return this.pos;
        }

        public boolean equals(Object o) {
            if (o instanceof NodeToSegs) {
                return this.compareTo((NodeToSegs)o) == 0;
            }
            return false;
        }
    }
}

