/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MergeSourceBuildingVisitor
extends AbstractVisitor {
    private DataSet selectionBase;
    private DataSet hull;
    private HashMap<OsmPrimitive, PrimitiveData> mappedPrimitives;

    public MergeSourceBuildingVisitor(DataSet selectionBase) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(selectionBase, "selectionBase");
        this.selectionBase = selectionBase;
        this.hull = new DataSet();
        this.mappedPrimitives = new HashMap();
    }

    protected boolean isInSelectionBase(OsmPrimitive primitive) {
        return this.selectionBase.getSelected().contains(primitive);
    }

    protected boolean isAlreadyRemembered(OsmPrimitive primitive) {
        return this.mappedPrimitives.keySet().contains(primitive);
    }

    protected void rememberNode(Node n) {
        if (this.isAlreadyRemembered(n)) {
            return;
        }
        this.mappedPrimitives.put(n, n.save());
    }

    protected void rememberWay(Way w) {
        if (this.isAlreadyRemembered(w)) {
            return;
        }
        WayData clone = w.save();
        ArrayList<Long> newNodes = new ArrayList<Long>(w.getNodesCount());
        for (Node n : w.getNodes()) {
            newNodes.add(this.mappedPrimitives.get(n).getUniqueId());
        }
        clone.setNodes(newNodes);
        this.mappedPrimitives.put(w, clone);
    }

    protected void rememberRelation(Relation r) {
        RelationData clone;
        if (this.isAlreadyRemembered(r)) {
            clone = (RelationData)this.mappedPrimitives.get(r);
        } else {
            clone = r.save();
            this.mappedPrimitives.put(r, clone);
        }
        ArrayList<RelationMemberData> newMembers = new ArrayList<RelationMemberData>();
        for (RelationMember member : r.getMembers()) {
            newMembers.add(new RelationMemberData(member.getRole(), this.mappedPrimitives.get(member.getMember())));
        }
        clone.setMembers(newMembers);
    }

    protected void rememberRelationPartial(Relation r) {
        if (this.isAlreadyRemembered(r)) {
            return;
        }
        RelationData clone = r.save();
        clone.getMembers().clear();
        this.mappedPrimitives.put(r, clone);
    }

    protected void rememberIncomplete(OsmPrimitive primitive) {
        if (this.isAlreadyRemembered(primitive)) {
            return;
        }
        PrimitiveData clone = primitive.save();
        clone.setIncomplete(true);
        this.mappedPrimitives.put(primitive, clone);
    }

    public void visit(Node n) {
        this.rememberNode(n);
    }

    public void visit(Way w) {
        for (Node n : w.getNodes()) {
            n.visit(this);
        }
        this.rememberWay(w);
    }

    public void visit(Relation r) {
        this.rememberRelationPartial(r);
        for (RelationMember member : r.getMembers()) {
            if (this.isAlreadyRemembered(member.getMember())) continue;
            if (this.isInSelectionBase(member.getMember()) || member.getMember().isNew()) {
                member.getMember().visit(this);
                continue;
            }
            this.rememberIncomplete(member.getMember());
        }
        this.rememberRelation(r);
    }

    protected void buildHull() {
        for (PrimitiveData primitive : this.mappedPrimitives.values()) {
            this.hull.getPrimitiveById(primitive, true);
        }
        for (PrimitiveData primitive : this.mappedPrimitives.values()) {
            if (!(primitive instanceof NodeData) || primitive.isIncomplete()) continue;
            this.hull.getPrimitiveById(primitive).load(primitive);
        }
        for (PrimitiveData primitive : this.mappedPrimitives.values()) {
            if (primitive instanceof NodeData || primitive.isIncomplete()) continue;
            this.hull.getPrimitiveById(primitive).load(primitive);
        }
    }

    public DataSet build() {
        for (OsmPrimitive primitive : this.selectionBase.getSelected()) {
            primitive.visit(this);
        }
        this.buildHull();
        return this.hull;
    }
}

