/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame mainFrame) {
        mainFrame.setContentPane(contentPanePrivate);
        mainFrame.setJMenuBar(this.menu);
        mainFrame.setBounds(bounds);
        mainFrame.setIconImage(ImageProvider.get("logo.png").getImage());
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                if (!Main.saveUnsavedModifications()) {
                    return;
                }
                Main.saveGuiGeometry();
                System.exit(0);
            }
        });
        mainFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor") + "\n\n" + I18n.tr("usage") + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options") + ":\n" + "\t--help|-?|-h                              " + I18n.tr("Show this help") + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument") + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box") + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)") + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)") + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps") + "\n" + "\t--downloadgps=<url>                       " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z) as raw gps") + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search") + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode") + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default") + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language") + "\n\n" + I18n.tr("options provided as Java system properties") + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ") + I18n.tr("Change the folder for all user settings") + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes") + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples") + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.") + "\n" + I18n.tr("Make sure you load some data if you use --selection.") + "\n");
    }

    private static Map<String, Collection<String>> buildCommandLineArgumentMap(String[] args) {
        HashMap<String, Collection<String>> argMap = new HashMap<String, Collection<String>>();
        for (String arg : args) {
            int i;
            if ("-h".equals(arg) || "-?".equals(arg)) {
                arg = "--help";
            }
            if (!arg.startsWith("--")) {
                arg = "--download=" + arg;
            }
            String key = (i = arg.indexOf(61)) == -1 ? arg.substring(2) : arg.substring(2, i);
            String value = i == -1 ? "" : arg.substring(i + 1);
            LinkedList<String> v = (LinkedList<String>)argMap.get(key);
            if (v == null) {
                v = new LinkedList<String>();
            }
            v.add(value);
            argMap.put(key, v);
        }
        return argMap;
    }

    public static void main(String[] argArray) {
        I18n.init();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            public void refresh() {
            }

            public PermissionCollection getPermissions(CodeSource codesource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        System.setProperty("sun.awt.exception.handler", BugReportExceptionHandler.class.getName());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        final Map<String, Collection<String>> args = MainApplication.buildCommandLineArgumentMap(argArray);
        Main.pref.init(args.containsKey("reset-preferences"));
        if (args.containsKey("language")) {
            I18n.set((String)args.get("language").toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        DefaultAuthenticator.createInstance(CredentialsManagerFactory.getCredentialManager());
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        ProxySelector.setDefault(new DefaultProxySelector(ProxySelector.getDefault()));
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManagerFactory.getCredentialManager());
        if (args.containsKey("help")) {
            MainApplication.showHelp();
            System.exit(0);
        }
        SplashScreen splash = new SplashScreen();
        ProgressMonitor monitor = splash.getProgressMonitor();
        monitor.beginTask(I18n.tr("Initializing"));
        monitor.setTicksCount(7);
        splash.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        List<PluginInformation> pluginsToLoad = PluginHandler.buildListOfPluginsToLoad(splash, monitor.createSubTaskMonitor(1, false));
        if (!pluginsToLoad.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splash)) {
            monitor.subTask(I18n.tr("Updating plugins..."));
            pluginsToLoad = PluginHandler.updatePlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        }
        monitor.worked(1);
        monitor.subTask(I18n.tr("Installing updated plugins"));
        PluginHandler.installDownloadedPlugins(true);
        monitor.worked(1);
        monitor.subTask(I18n.tr("Loading early plugins"));
        PluginHandler.loadEarlyPlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        monitor.worked(1);
        monitor.subTask(I18n.tr("Setting defaults"));
        MainApplication.preConstructorInit(args);
        MainApplication.removeObsoletePreferences();
        monitor.worked(1);
        monitor.indeterminateSubTask(I18n.tr("Creating main GUI"));
        JFrame mainFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor"));
        Main.parent = mainFrame;
        Main.addListener();
        final MainApplication main = new MainApplication(mainFrame);
        monitor.worked(1);
        monitor.subTask(I18n.tr("Loading plugins"));
        PluginHandler.loadLatePlugins(splash, pluginsToLoad, monitor.createSubTaskMonitor(1, false));
        monitor.worked(1);
        toolbar.refreshToolbarControl();
        splash.setVisible(false);
        splash.dispose();
        mainFrame.setVisible(true);
        boolean maximized = Boolean.parseBoolean(Main.pref.get("gui.maximized"));
        if (!args.containsKey("no-maximize") && maximized || args.containsKey("maximize")) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                mainFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                main.postConstructorProcessCmdLine(args);
            }
        });
    }

    public static void removeObsoletePreferences() {
        String[] obsolete;
        for (String key : obsolete = new String[]{"proxy.anonymous", "proxy.enable"}) {
            if (!Main.pref.hasKey(key)) continue;
            Main.pref.removeFromCollection(key, Main.pref.get(key));
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", key));
        }
    }
}

